/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.geom.Rectangle2D;
import rdr.EndOfStream;
import rfb.AliasParameter;
import rfb.BoolParameter;
import rfb.Configuration;
import rfb.IntParameter;
import rfb.LogWriter;
import rfb.StringParameter;
import vncviewer.CConn;
import vncviewer.MessageBox;

public class VNCViewer
extends Applet
implements Runnable {
    BoolParameter useLocalCursor = new BoolParameter("UseLocalCursor", "Render the mouse cursor locally", true);
    BoolParameter autoSelect = new BoolParameter("AutoSelect", "Auto select pixel format and encoding", true);
    BoolParameter fullColour = new BoolParameter("FullColour", "Use full colour - otherwise 6-bit colour is used until AutoSelect decides the link is fast enough", false);
    AliasParameter fullColor = new AliasParameter("FullColor", "Alias for FullColour", this.fullColour);
    StringParameter preferredEncoding = new StringParameter("PreferredEncoding", "Preferred encoding to use (ZRLE, hextile or raw) - implies AutoSelect=0", null);
    BoolParameter viewOnly = new BoolParameter("ViewOnly", "Don't send any mouse or keyboard events to the server", false);
    BoolParameter shared = new BoolParameter("Shared", "Don't disconnect other viewers upon connection - share the desktop instead", false);
    BoolParameter acceptClipboard = new BoolParameter("AcceptClipboard", "Accept clipboard changes from the server", true);
    BoolParameter sendClipboard = new BoolParameter("SendClipboard", "Send clipboard changes to the server", true);
    BoolParameter alwaysShowServerDialog = new BoolParameter("AlwaysShowServerDialog", "Always show the server dialog even if a server has been specified in an applet parameter or on the command line", false);
    StringParameter vncServerName = new StringParameter("Server", "The VNC server <host>[:<dpyNum>] or <host>::<port>", null);
    IntParameter vncServerPort = new IntParameter("Port", "The VNC server's port number, assuming it is on the host from which the applet was downloaded", 0);
    Thread thread;
    boolean applet;
    boolean firstApplet;
    Image logo;
    Label versionLabel;
    static int nViewers;
    static LogWriter vlog;

    public static void main(String[] stringArray) {
        VNCViewer vNCViewer = new VNCViewer(stringArray);
        vNCViewer.start();
    }

    public VNCViewer(String[] stringArray) {
        this.applet = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-log")) {
                if (++i >= stringArray.length) {
                    VNCViewer.usage();
                }
                System.err.println("Log setting: " + stringArray[i]);
                LogWriter.setLogParams(stringArray[i]);
                continue;
            }
            if (Configuration.setParam(stringArray[i])) continue;
            if (stringArray[i].charAt(0) == '-') {
                if (i + 1 < stringArray.length && Configuration.setParam(stringArray[i].substring(1), stringArray[i + 1])) {
                    ++i;
                    continue;
                }
                VNCViewer.usage();
            }
            if (this.vncServerName.getValue() != null) {
                VNCViewer.usage();
            }
            this.vncServerName.setParam(stringArray[i]);
        }
    }

    public static void usage() {
        String string = "\nusage: vncviewer [options/parameters] [host:displayNum] [options/parameters]\n\nOptions:\n  -log <level>    configure logging level\n\nParameters can be turned on with -<param> or off with -<param>=0\nParameters which take a value can be specified as -<param> <value>\nOther valid forms are <param>=<value> -<param>=<value> --<param>=<value>\nParameter names are case-insensitive.  The parameters are:\n\n" + Configuration.listParams();
        System.err.print(string);
        System.exit(1);
    }

    public VNCViewer() {
        vlog.info("Blah");
        this.applet = true;
        this.firstApplet = true;
    }

    public static void newViewer(VNCViewer vNCViewer) {
        VNCViewer vNCViewer2 = new VNCViewer();
        vNCViewer2.applet = vNCViewer.applet;
        vNCViewer2.firstApplet = false;
        vNCViewer2.start();
    }

    public void init() {
        vlog.debug("init called");
        this.setBackground(Color.white);
        this.logo = this.getImage(this.getDocumentBase(), "vino-client.png");
    }

    public void start() {
        vlog.debug("start called");
        ++nViewers;
        if (this.firstApplet) {
            this.alwaysShowServerDialog.setParam(true);
            Configuration.readAppletParams(this);
            String string = this.getCodeBase().getHost();
            if (this.vncServerName.getValue() == null && this.vncServerPort.getValue() != 0) {
                int n = this.vncServerPort.getValue();
                this.vncServerName.setParam(string + (n >= 5900 && n <= 5999 ? ":" + (n - 5900) : "::" + n));
            }
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.logo, (this.getWidth() - this.logo.getWidth(this)) / 2, 0, this);
        int n = this.logo.getHeight(this) + 20;
        String string = "GNOME Remote Desktop";
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        graphics.drawString(string, (this.getWidth() - (int)rectangle2D.getWidth()) / 2, n);
    }

    public void run() {
        CConn cConn;
        block8: {
            cConn = null;
            try {
                cConn = new CConn(this);
                if (cConn.init(null, this.vncServerName.getValue(), this.alwaysShowServerDialog.getValue())) {
                    while (true) {
                        cConn.processMsg();
                    }
                }
            }
            catch (EndOfStream endOfStream) {
                vlog.info(endOfStream.toString());
            }
            catch (Exception exception) {
                if (cConn != null) {
                    cConn.removeWindow();
                }
                if (cConn != null && cConn.shuttingDown) break block8;
                exception.printStackTrace();
                new MessageBox(exception.toString());
            }
        }
        if (cConn != null) {
            cConn.removeWindow();
        }
        if (!this.applet && --nViewers == 0) {
            System.exit(0);
        }
    }

    static {
        vlog = new LogWriter("main");
    }
}

