#
#    Copyright 1999,2000 by the Purdue Research Foundation for CERIAS (the
#    Center for Education and Research in Information Assurance and
#    Security).  All rights reserved.  This work may be used for
#    non-profit educational and research purposes only.  Any copies made
#    of this file or portions of its contents must include this copyright
#    statement.  For information on reuse, licensing, or copying, contact
#    <cerias-info@cerias.purdue.edu>.
#
#    This software is experimental in nature and is provided without any
#    express or implied warranties, including, without limitation, the
#    implied warranties of merchantability and fitness for any particular
#    purpose.
#
#  $Id: verbose.pat,v 1.4 2000/01/31 03:56:38 flack Exp $
#
#  Patches the trace routines in LLkParser.java so more informative tracing
#  information is produced, and tracing can be enabled/disabled at run time
#  with the traceParse system property.  Useful for parsing binary data, where
#  you can't just look up the "line" number in a diagnostic message and see
#  what the trouble was.
#
#  Chapman Flack, flack@cs.purdue.edu
#

*** antlr/LLkParser.java	Fri Jan 21 19:56:36 2000
--- antlr/LLkParser.java	Sun Jan 30 22:01:27 2000
***************
*** 45,50 ****
--- 45,60 ----
  	 * consumed will be overwritten with the 3rd.
  	 */
  	public void consume() {
+ 		if ( tracing  &&  inputState.guessing == 0 ) {
+ 		  for ( int i = indentLevel; i > 0; --i )
+ 		    System.out.print( " ");
+ 		  try {
+ 		    System.out.println( LT(1).toString());
+ 		  }
+ 		  catch ( TokenStreamException e ) {
+ 		    System.out.println( "TokenStreamException");
+ 		  }
+ 		}
  		inputState.input.consume();
  	}
  	public int LA(int i) throws TokenStreamException {
***************
*** 53,73 ****
  	public Token LT(int i) throws TokenStreamException {
  		return inputState.input.LT(i);
  	}
  	private void trace(String ee, String rname) throws TokenStreamException {
  		System.out.print(ee + rname + ((inputState.guessing>0)?"; [guessing]":"; "));
  		for (int i = 1; i <= k; i++)
  		{
  			if (i != 1) {
  				System.out.print(", ");
  			}
! 			System.out.print("LA(" + i + ")==" + LT(i).getText());
  		}
! 		System.out.println("");
  	}
  	public void traceIn(String rname) throws TokenStreamException {
  		trace("enter ", rname);
  	}
  	public void traceOut(String rname) throws TokenStreamException {
  		trace("exit ", rname);
  	}
  }
--- 63,90 ----
  	public Token LT(int i) throws TokenStreamException {
  		return inputState.input.LT(i);
  	}
+ 	private static boolean tracing = Boolean.getBoolean( "traceParse");
+ 	private int indentLevel = 0;
  	private void trace(String ee, String rname) throws TokenStreamException {
+ 		if ( !tracing ) return;
+ 		for ( int i = indentLevel; i > 0; --i )
+ 		  System.out.print( " ");
  		System.out.print(ee + rname + ((inputState.guessing>0)?"; [guessing]":"; "));
  		for (int i = 1; i <= k; i++)
  		{
  			if (i != 1) {
  				System.out.print(", ");
  			}
! 			System.out.print("LT(" + i + ")==" + LT(i));
  		}
! 		System.out.println();
  	}
  	public void traceIn(String rname) throws TokenStreamException {
  		trace("enter ", rname);
+ 		++indentLevel;
  	}
  	public void traceOut(String rname) throws TokenStreamException {
+ 		--indentLevel;
  		trace("exit ", rname);
  	}
  }
