 /*
  * delay_signaling(), enable_signaling - delay signal delivery for a while
  * 
  * Author: Wietse Venema
  */
#include <sys/types.h>
#include <sys/signal.h>
#include <syslog.h>

static sigset_t saved_sigmask;
static sigset_t block_sigmask;
static int delaying;
static int init_done;

/* init_mask - compute signal mask only once */

static void init_mask()
{
    int     sig;

    init_done = 1;
    sigemptyset(&block_sigmask);
    for (sig = 1; sig < NSIG; sig++)
	sigaddset(&block_sigmask, sig);
}

/* enable_signaling - deliver delayed signals and disable signal delay */

int     enable_signaling()
{
    if (delaying != 0) {
	delaying = 0;
	if (sigprocmask(SIG_SETMASK, &saved_sigmask, (sigset_t *) 0) < 0) {
	    syslog(LOG_ERR, "sigprocmask: %m");
	    return (-1);
	}
    }
    return (0);
}

/* delay_signaling - save signal mask and block all signals */

int     delay_signaling()
{
    if (init_done == 0)
	init_mask();
    if (delaying == 0) {
	delaying = 1;
	if (sigprocmask(SIG_BLOCK, &block_sigmask, &saved_sigmask) < 0) {
	    syslog(LOG_ERR, "sigprocmask: %m");
	    return (-1);
	}
    }
    return (0);
}

#ifdef TEST

#include <stdio.h>

void    gotsig(sig)
int     sig;
{
    printf("Got signal %d\n", sig);
}

main(argc, argv)
int     argc;
char  **argv;
{
    signal(SIGINT, gotsig);
    signal(SIGQUIT, gotsig);

    delay_signaling();
    sleep(5);
    enable_signaling();
    exit(0);
}

#endif
