#include <shadow.h>

static  xx_check_pwd(pwd, sp)
struct passwd *pwd;
struct spwd *sp;
{
    long    today = DAY_NOW;

    /* Leave fake password field alone if password has expired. */

    if (sp->sp_max > 0 && today > sp->sp_lstchg + sp->sp_max)
	return;

    /* Leave fake password field alone if account has expired. */

    if (sp->sp_expire > 0 && today > sp->sp_expire)
	return;

    pwd->pw_passwd = sp->sp_pwdp;
}

struct passwd *fake_getpwuid(uid)
int     uid;
{
    struct passwd *pwd;
    struct spwd *sp;
    struct passwd *getpwuid();

    if ((pwd = getpwuid(uid)) && (sp = getspnam(pwd->pw_name)))
	xx_check_pwd(pwd, sp);
    return (pwd);
}

struct passwd *fake_getpwnam(name)
const char *name;
{
    struct passwd *pwd;
    struct spwd *sp;
    struct passwd *getpwnam();

    if ((pwd = getpwnam(name)) && (sp = getspnam(name)))
	xx_check_pwd(pwd, sp);
    return (pwd);
}

void    fake_endpwent()
{
    endpwent();
    endspent();
}

#define	getpwuid fake_getpwuid
#define	getpwnam fake_getpwnam
#define endpwent fake_endpwent
