/*
 * long randomnumber(bytes)
 *	returns a non-negative random number that has a theoretical
 *	uniform distribution from 0 to the maximum number that can be
 *	represented in the specified number of bytes.  In other words,
 *	the random number is in the range [0 .. 2 ^ ((8 * bytes) - 1)].
 *	If "USE_RANDOM" is defined this file uses the function "random"
 *	to generate the random number.  If "USE_RAND" is defined this
 *	file uses the function "rand" to generate the random number.
 *
 *	Written by William LeFebvre, Argonne National Laboratory
 */

#include <sys/types.h>
#include <sys/time.h>
#include <stdlib.h>

#ifdef  USE_RANDOM
#define SEED srandom
#define RAND random
#endif /* USE_RANDOM */

#ifdef USE_RAND
#define SEED srand
#define RAND rand
#endif /* USE_RAND */

long
randomnumber(bytes)
int bytes;
{
    static int initt = 0;
    register long result = 0;
    register int i;
 
    if(!initt)
    {
	struct timeval tv;
 
	/* use all bits: ^ for uncorrelated data, + for correlated data */
	gettimeofday(&tv, (struct timezone *) 0);
	SEED((int)(tv.tv_sec ^ tv.tv_usec) ^ (getpid() + getppid()));
	initt++;
    }
    while (bytes-- > 0)
    {
	result <<= 8;
	i = RAND();
	i = ((i & 0xff00) >> 8) ^ (i & 0xff);
	result |= i;
    }
    return(result);
}

