# -*- perl -*-
my $min_perl_version = 5.004;

if ($] < $min_perl_version) {
  print STDERR "This program will not work with perl version $]. It requires perl version $min_perl_version or higher\n";
  exit 1;
}

use strict;
require ExtUtils::MakeMaker;

if (not defined $ENV{'RPMBUILD'}) {
  my($ok) = 1;
  my($recommended) = 0;

  print "Checking for Time::HiRes 1.12 ... ";
  $@ = '';
  eval "use Time::HiRes 1.12 ();";
  if ($@) {
    $ok = 0;
    print("\nYou don't have the Time::HiRes 1.12 module installed.\n");
    print("Would you like to install the module now? ");
    $_ = <>;
    if (/^y$/i or /^yes$/i) {
      use CPAN;
      my $obj = CPAN::Shell->expand("Module", "Time::HiRes");
      $obj->install;
    }
  } else {
    print "ok\n";
  }

  print "Checking for Date::Calc ... ";
  $@ = '';
  eval "use Date::Calc ();";
  if ($@) {
    $ok = 0;
    print("\nYou don't have the Date::Calc module installed.\n");
    print("Would you like to install the module now? ");
    $_ = <>;
    if (/^y$/i or /^yes$/i) {
      use CPAN;
      my $obj = CPAN::Shell->expand("Module", "Date::Calc");
      $obj->install;
    }
  } else {
    print "ok\n";
  }

  print "Checking for Date::Format ... ";
  $@ = '';
  eval "use Date::Format ();";
  if ($@) {
    $ok = 0;
    print("\nYou don't have the Date::Format module installed.\n");
    print("Would you like to install the module now? ");
    $_ = <>;
    if (/^y$/i or /^yes$/i) {
      use CPAN;
      my $obj = CPAN::Shell->expand("Module", "Date::Format");
      $obj->install;
    }
  } else {
    print "ok\n";
  }
  
  if (!$ok) {
    exit 1;
  }


  print "Checking for File::Tail ... ";
  $@ = '';
  eval "use File::Tail ();";
  if ($@) {
    $ok = 0;
    print("\nYou don't have the File::Tail module installed.\n");
    print("Would you like to install the module now? ");
    $_ = <>;
    if (/^y$/i or /^yes$/i) {
      use CPAN;
      my $obj = CPAN::Shell->expand("Module", "File::Tail");
      $obj->install;
    }
  } else {
    print "ok\n";
  }
  
  if (!$ok) {
    exit 1;
  }
}

use lib "lib";

ExtUtils::MakeMaker::WriteMakefile(
    'NAME'	   => 'swatch',
    'VERSION_FROM' => 'swatch',
    'EXE_FILES'    => [ 'swatch', 'swatch_oldrc2newrc' ],
    'dist'         => { 'SUFFIX'       => ".gz",
			'DIST_DEFAULT' => 'all tardist',
			'COMPRESS'     => "gzip -9f" },
    'realclean'    => { 'FILES' => '' },
    'clean'        => { 'FILES' => '' },
);


package MY;

sub postamble {
#    my $perl = $^X;
}

sub libscan {
    my($self, $path) = @_;
    if ($path =~ /\~$/) {
	undef;
    } else {
	$path;
    }
}
