#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <net/if.h>
#include <sys/fcntl.h>
#include <sys/sockio.h>
#include <sys/pfmod.h>
#include <sys/stropts.h>
#include <sys/ethernet.h>
#include <sys/dlpi.h>
 
#include <netinet/in.h>
#include <netdb.h>
#include <ctype.h>

AttachDevice(fd,devno)
int fd,devno;
{
        int retval;
        int flags = RS_HIPRI;
        struct strbuf ctlbuf;
        union DL_primitives rcvbuf;
        dl_attach_req_t Request;
 
 
        /* bind to underlying interface */
        Request.dl_primitive    = DL_ATTACH_REQ;
        Request.dl_ppa          = devno;
        ctlbuf.len              = sizeof(Request);
        ctlbuf.buf              = (caddr_t)&Request;
 
        if (putmsg(fd, &ctlbuf ,NULL,0)  < 0) {
                perror("Attach Device:");
                return(0);
        }
 
        ctlbuf.maxlen = sizeof(union DL_primitives);
        ctlbuf.len = 0;
        ctlbuf.buf = (char *)&rcvbuf;
        if ((retval = getmsg(fd, &ctlbuf ,NULL, &flags))  < 0) {
                perror("Attach Device ack!");
                return(0);
        }
 
        return (Acknowledge(&rcvbuf,DL_OK_ACK,"DL_ATTACH_REQ"));
}

BindProtocol(fd,sap,max_conind,service_mode, conn_mgmt, xidtest_flg )
int     fd,sap,max_conind,service_mode, conn_mgmt, xidtest_flg ;
{
        int retval;
        int flags = RS_HIPRI;
        struct strbuf ctlbuf;
        union DL_primitives rcvbuf;
        dl_bind_req_t   BindRequest;
 
 
        BindRequest.dl_primitive                = DL_BIND_REQ;
        BindRequest.dl_sap                      = sap;
        BindRequest.dl_max_conind               = max_conind;
        BindRequest.dl_service_mode             = service_mode;
        BindRequest.dl_conn_mgmt                = conn_mgmt;
        BindRequest.dl_xidtest_flg              = xidtest_flg;
 
        ctlbuf.len = sizeof(BindRequest);
        ctlbuf.buf = (caddr_t)&BindRequest;
 
        if (putmsg(fd, &ctlbuf ,NULL,0)  < 0) {
                perror("Bind Protocol:");
                return(0);
        }
 
        ctlbuf.maxlen = sizeof(union DL_primitives);
        ctlbuf.len = 0;
        ctlbuf.buf = (char *)&rcvbuf;
        if ((retval = getmsg(fd, &ctlbuf ,NULL, &flags))  < 0) {
                perror("Bind Protocol ACK!");
                return(0);
        }
 
        return (Acknowledge(&rcvbuf,DL_BIND_ACK,"DL_BIND_REQ"));
}

/* DLPI Support Routines */
 
Acknowledge (dlp_p,ack,msg)
union DL_primitives *dlp_p;
int ack;
char *msg;
{
        if (dlp_p->dl_primitive != ack) {
                fprintf(stderr,"dlpi: %s is nacked.\n",msg);
                if (dlp_p->dl_primitive == DL_ERROR_ACK)
                        fprintf(stderr, "dlpi: dlpi_errno %d\n"
                                        "dlpi: unix_errno %d\n",
                        dlp_p->error_ack.dl_errno,
                        dlp_p->error_ack.dl_unix_errno);
                else
                        fprintf(stderr,"dlpi: spiritual primitive %d.\n",
                        dlp_p->dl_primitive);
                return(0);
        }
        return(1);
}

PromMode(fd,level)
int     fd,level;
{
        int retval;
        int flags = RS_HIPRI;
        struct strbuf ctlbuf;
        union DL_primitives rcvbuf;
        dl_promiscon_req_t PromRequest;
 
 
        PromRequest.dl_primitive                = DL_PROMISCON_REQ;
        PromRequest.dl_level                    = level;
 
        ctlbuf.maxlen = 0;
        ctlbuf.len = sizeof(PromRequest);
        ctlbuf.buf = (caddr_t)&PromRequest;
 
        if (putmsg(fd, &ctlbuf ,NULL,0)  < 0) {
                perror("Prom Mode:");
                return(0);
        }
 
        ctlbuf.maxlen = sizeof(union DL_primitives);
        ctlbuf.len = 0;
        ctlbuf.buf = (char *)&rcvbuf;
        if ((retval = getmsg(fd, &ctlbuf ,NULL, &flags))  < 0) {
                perror("Prom Mode ack!");
                return(0);
        }
 
        return (Acknowledge(&rcvbuf,DL_OK_ACK,"DL_PROMISCON_REQ"));
}

/*
 * Get physical interface MAC address
 */

GetMACAddress(int fd, char *buf)
{
	dl_phys_addr_req_t phys_addr_req;
	struct strbuf ctl;
	union DL_primitives dlp;
	int flags;

	phys_addr_req.dl_primitive = DL_PHYS_ADDR_REQ;
	phys_addr_req.dl_addr_type = DL_CURR_PHYS_ADDR;

	ctl.maxlen = 0;
	ctl.len = DL_PHYS_ADDR_REQ_SIZE;
	ctl.buf = (char *) &phys_addr_req;

	flags = RS_HIPRI;

	if (putmsg(fd, &ctl, (struct strbuf *) NULL, 0) < 0) {
		perror("dlphysaddrreq: putmsg");
		return(0);
	}

	ctl.maxlen = sizeof(union DL_primitives);
	ctl.len = sizeof(dl_phys_addr_ack_t);
	ctl.buf = (char *)&dlp;

	if (getmsg(fd, &ctl, (struct strbuf *) NULL, &flags) < 0) {
		perror("Ethernet address ack!");
		return(0);
	}

	if (Acknowledge(&dlp, DL_PHYS_ADDR_ACK, "DL_PHYS_ADDR_REQ")) {
		memcpy( buf, &ctl.buf[dlp.physaddr_ack.dl_addr_offset], 6);
		return (1);
	}
	return(0);

}

/*
 * DL INFO request
 */

dlinforeq(fd, buf)
{
	dl_info_req_t info_req;
	struct strbuf ctl;
	char tbuf[BUFSIZ];
	union DL_primitives *dlp;
	int flags;

	dlp = (union DL_primitives *) &tbuf;
	info_req.dl_primitive = DL_INFO_REQ;

	ctl.maxlen = 0;
	ctl.len = DL_INFO_REQ_SIZE;
	ctl.buf = (char *) &info_req;

	flags = RS_HIPRI;

	if (putmsg(fd, &ctl, (struct strbuf *) NULL, flags) < 0) {
		perror("putmsg: dlinfo_req");
		return(0);
	}

	ctl.maxlen = BUFSIZ;
	ctl.len = 0;
	ctl.buf = tbuf;

	if (getmsg(fd, &ctl, (struct strbuf *) NULL, &flags) < 0) {
		perror("Ethernet address ack!");
		return(0);
	}

	if (Acknowledge(dlp, DL_INFO_ACK, "DL_INFO_REQ")) {
		memcpy( buf, (char *) &ctl.buf[dlp->info_ack.dl_addr_offset], 6);
		return (1);
	}
	return(0);
}
