package org.gnu.libebook;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;
import org.gnu.libedataserver.EDSMemStruct;

public class EContactName extends EDSMemStruct
{
    public EContactName(Handle handle)
    {
        super(handle);
    }

    public static EContactName getEContactName(Handle handle)
    {
        if (handle == null)
            return null;

        EContactName obj = (EContactName) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EContactName(handle) : obj;
    }

    public String getName()
    {
        return e_contact_name_to_string(getHandle());
    }

    public String getFamily()
    {
        return e_contact_name_get_family(getHandle());
    }

    public String getGiven()
    {
        return e_contact_name_get_given(getHandle());
    }

    public String getAdditional()
    {
        return e_contact_name_get_additional(getHandle());
    }

    public String getPrefixes()
    {
        return e_contact_name_get_prefixes(getHandle());
    }

    public String getSuffixes()
    {
        return e_contact_name_get_suffixes(getHandle());
    }

    public void setFamily(String value)
    {
        e_contact_name_set_family(getHandle(), value);
    }

    public void setGiven(String value)
    {
        e_contact_name_set_given(getHandle(), value);
    }

    public void setAdditional(String value)
    {
        e_contact_name_set_additional(getHandle(), value);
    }

    public void setPrefixes(String value)
    {
        e_contact_name_set_prefixes(getHandle(), value);
    }

    public void setSuffixes(String value)
    {
        e_contact_name_set_suffixes(getHandle(), value);
    }

    public static EContactName createContactName()
    {
        return getEContactName(e_contact_name_new());
    }

    public static EContactName createContactName(String name)
    {
        return getEContactName(e_contact_name_from_string(name));
    }

    native static private Handle e_contact_name_new();
    native static private Handle e_contact_name_from_string(String name);

    native static private String e_contact_name_to_string(Handle handle);

    native static private String e_contact_name_get_family(Handle handle);
    native static private String e_contact_name_get_given(Handle handle);
    native static private String e_contact_name_get_additional(Handle handle);
    native static private String e_contact_name_get_prefixes(Handle handle);
    native static private String e_contact_name_get_suffixes(Handle handle);

    native static private void e_contact_name_set_family(Handle handle, String value);
    native static private void e_contact_name_set_given(Handle handle, String value);
    native static private void e_contact_name_set_additional(Handle handle, String value);
    native static private void e_contact_name_set_prefixes(Handle handle, String value);
    native static private void e_contact_name_set_suffixes(Handle handle, String value);

}
