/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "gtk_java.h"
#include "jg_jnu.h"
#include <libebook/e-contact.h>
#include "org_gnu_libebook_EContactName.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1new
(JNIEnv *env, jclass cls)
{
    return getStructHandle(env, e_contact_name_new(), NULL, (JGFreeFunc)e_contact_name_free);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_from_string
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1from_1string
(JNIEnv *env, jclass cls, jstring value)
{
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    EContactName *name = e_contact_name_from_string(value_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
    return getStructHandle(env, name, NULL, (JGFreeFunc)e_contact_name_free);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_to_string
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1to_1string
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_contact_name_to_string(contact_name));
}


/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_get_family
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1get_1family
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_name->family);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_set_family
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1set_1family
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_name->family = value_g;
}


/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_get_given
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1get_1given
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_name->given);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_set_given
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1set_1given
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_name->given = value_g;
}


/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_get_additional
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1get_1additional
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_name->additional);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_set_additional
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1set_1additional
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_name->additional = value_g;
}


/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_get_prefixes
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1get_1prefixes
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_name->prefixes);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_set_prefixes
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1set_1prefixes
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_name->prefixes = value_g;
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_get_suffixes
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1get_1suffixes
(JNIEnv *env, jclass cls, jobject obj)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, contact_name->suffixes);
}

/*
 * Class:     org_gnu_libebook_EContactName
 * Method:    e_contact_name_set_suffixes
 */
JNIEXPORT void JNICALL Java_org_gnu_libebook_EContactName_e_1contact_1name_1set_1suffixes
(JNIEnv *env, jclass cls, jobject obj, jstring value)
{
    EContactName *contact_name = (EContactName*)getPointerFromHandle(env, obj);
    char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    contact_name->suffixes = value_g;
}



#ifdef __cplusplus
}

#endif
