/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include "org_gnu_libedataserver_ESource.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1new
(JNIEnv *env, jclass cls, jstring name, jstring relative_uri)
{
    const char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    const char* relative_uri_g = (char*)(*env)->GetStringUTFChars(env, relative_uri, 0);
    ESource *ret = e_source_new(name_g, relative_uri_g);

    (*env)->ReleaseStringUTFChars(env, name, name_g);
    (*env)->ReleaseStringUTFChars(env, relative_uri, relative_uri_g);

    return getGObjectHandle(env, ret);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_new_with_absolute_uri
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1new_1with_1absolute_1uri
(JNIEnv *env, jclass cls, jstring name, jstring absolute_uri)
{
    const char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    const char* absolute_uri_g = (char*)(*env)->GetStringUTFChars(env, absolute_uri, 0);
    ESource *ret = e_source_new_with_absolute_uri(name_g, absolute_uri_g);

    (*env)->ReleaseStringUTFChars(env, name, name_g);
    (*env)->ReleaseStringUTFChars(env, absolute_uri, absolute_uri_g);

    return getGObjectHandle(env, ret);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_new_from_standalone_xml
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1new_1from_1standalone_1xml
(JNIEnv *env, jclass cls, jstring xml)
{
    const char* xml_g = (char*)(*env)->GetStringUTFChars(env, xml, 0);
    ESource *ret = e_source_new_from_standalone_xml(xml_g);
    (*env)->ReleaseStringUTFChars(env, xml, xml_g);

    return getGObjectHandle(env, ret);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_copy
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1copy
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, e_source_copy(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_equal
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1equal
(JNIEnv *env, jclass cls, jobject lhs, jobject rhs)
{
    ESource *lhs_g = (ESource*)getPointerFromHandle(env, lhs);
    ESource *rhs_g = (ESource*)getPointerFromHandle(env, rhs);
    return e_source_equal(lhs_g, rhs_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_group
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1group
(JNIEnv *env, jclass cls, jobject obj, jobject e_source_group)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, e_source_group);
    e_source_set_group(e_source_g, e_source_group_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_name
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1name
(JNIEnv *env, jclass cls, jobject obj, jstring name)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    const char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    e_source_set_name(e_source_g, name_g);
    (*env)->ReleaseStringUTFChars(env, name, name_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_relative_uri
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1relative_1uri
(JNIEnv *env, jclass cls, jobject obj, jstring relative_uri)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    const char* relative_uri_g = (char*)(*env)->GetStringUTFChars(env, relative_uri, 0);
    e_source_set_relative_uri(e_source_g, relative_uri_g);
    (*env)->ReleaseStringUTFChars(env, relative_uri, relative_uri_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_absolute_uri
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1absolute_1uri
(JNIEnv *env, jclass cls, jobject obj, jstring absolute_uri)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    const char* absolute_uri_g = (char*)(*env)->GetStringUTFChars(env, absolute_uri, 0);
    e_source_set_absolute_uri(e_source_g, absolute_uri_g);
    (*env)->ReleaseStringUTFChars(env, absolute_uri, absolute_uri_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_readonly
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1readonly
(JNIEnv *env, jclass cls, jobject obj, jboolean readonly)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    e_source_set_readonly(e_source_g, readonly);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_peek_group
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1peek_1group
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, e_source_peek_group(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_peek_uid
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1peek_1uid
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_peek_uid(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_peek_name
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1peek_1name
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_peek_name(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_peek_relative_uri
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1peek_1relative_1uri
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_peek_relative_uri(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_peek_absolute_uri
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1peek_1absolute_1uri
(JNIEnv *env, jclass cls, jobject obj)
{                                               
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_peek_absolute_uri(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_get_readonly
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1get_1readonly
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return e_source_get_readonly(e_source_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_get_uri
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1get_1uri
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_get_uri(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_to_standalone_xml
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1to_1standalone_1xml
(JNIEnv *env, jclass cls, jobject obj)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    return (*env)->NewStringUTF(env, e_source_to_standalone_xml(e_source_g));
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_set_property
 */
JNIEXPORT void JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1set_1property
(JNIEnv *env, jclass cls, jobject obj, jstring property, jstring value)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    const char* property_g = (char*)(*env)->GetStringUTFChars(env, property, 0);
    const char* value_g = (char*)(*env)->GetStringUTFChars(env, value, 0);
    e_source_set_property(e_source_g, property_g, value_g);
    (*env)->ReleaseStringUTFChars(env, property, property_g);
    (*env)->ReleaseStringUTFChars(env, value, value_g);
}

/*
 * Class:     org.gnu.libedataserver.ESource
 * Method:    e_source_get_property
 */
JNIEXPORT jstring JNICALL Java_org_gnu_libedataserver_ESource_e_1source_1get_1property
(JNIEnv *env, jclass cls, jobject obj, jstring property)
{
    ESource *e_source_g = (ESource*)getPointerFromHandle(env, obj);
    const char* property_g = (char*)(*env)->GetStringUTFChars(env, property, 0);
    jstring result = (*env)->NewStringUTF(env, e_source_get_property(e_source_g, property_g));
    (*env)->ReleaseStringUTFChars(env, property, property_g);
    return result;
}


#ifdef __cplusplus
}

#endif
