/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:30:40 EDT
 */

package org.gnu.gtk;
import org.gnu.gdk.Atom;
import org.gnu.gdk.Display;
import org.gnu.glib.Boxed;
/**
 *  The Clipboard object represents a clipboard of data shared between
 *  different processes or between different widgets in the same process.
 *
 * <p>TODO: This requires gdk.Selections
 * <p>TODO: callback functions
 */
public class Clipboard extends Boxed 
{
	/**
	 */
	protected Clipboard(int handle){
		this.handle = handle;
	}

	/**
	 * Clear the contents of the clipboard.
	 */
	public void clear() {
		gtk_clipboard_clear(handle);
	}
	
	/**
	 * Returns the clipboard object for the given selection. 
	 * See {@link Clipboard#getForDisplay(Display, Atom)} for complete details.
	 * @param atom  a {@link Atom} which identifies the clipboard to use
	 * @return  the appropriate clipboard object. If no clipboard already exists, 
	 * 			a new one will be created. Once a clipboard object has been created, 
	 * 			it is persistent for all time and cannot be freed.
	 */
	static public Clipboard get(Atom atom) {
		return new Clipboard(gtk_clipboard_get(atom.getHandle()));
	}
	
	/**
	 * 
	 * @param display the display for which the clipboard is to be retrieved or created
	 * @param atom a {@link Atom} which identifies the clipboard to use
	 * @return he appropriate clipboard object. If no clipboard already exists, 
	 * 			a new one will be created. Once a clipboard object has been created, 
	 * 			it is persistent for all time and cannot be freed.
	 * 
	 * TODO: write JNI
	 */
	static public Clipboard getForDisplay (Display display, Atom atom) {
		return null;
	}
	
	/**
	 * Gets the {@link Display} associated with clipboard.
	 *
	 * @return the {@link Display} associated with clipboard
	 */	
	public Display getDisplay() {
		return new Display(gtk_clipboard_get_display(handle));
	}
	
	/**
	 * Requests the contents of the clipboard as {@link SelectionData}
	 * @param atom an {@link Atom} representing the form into which the 
	 * 			clipboard owner should convert the selection
	 * @return  a newly-allocated {@link SelectionData} object or <code>NULL</code>   
	 * 			if retrieving the given target failed
	 * 
	 * TODO: write the JNI
	 */
	public SelectionData getContents(Atom atom) {
		return null;
	}
	
	public boolean isTextAvailable() {
		return gtk_clipboard_wait_is_text_available(handle);
	}
	
	/**
	 * Set the contents of the clipboard.
	 */
	public void setText(String text) {
		gtk_clipboard_set_text(handle, text, text.length());
	}
	
	/**
	 * Requests the contents of the clipboard as text.
	 */
	public String getText() {
		return gtk_clipboard_wait_for_text(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_clipboard_get (int selection);
    native static final protected int gtk_clipboard_get_display(int clipboard);
    native static final protected int gtk_clipboard_get_owner (int clipboard);
    native static final protected void gtk_clipboard_clear (int clipboard);
    native static final protected void gtk_clipboard_set_text (int clipboard, String text, int len);
    native static final protected String gtk_clipboard_wait_for_text (int clipboard);
    native static final protected boolean gtk_clipboard_wait_is_text_available (int clipboard);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

