/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Jeffrey S. Morgan
 *
 * This event is used to identify when an object gains and loses focus.
 * 
 * @see FocusListener
 */
public class FocusEvent extends GtkEvent {

	public static class Type extends GtkEventType{
		private Type(int id, String name){
			super(id, name);
		}

		/**
		 * This event indicates that the source has focus now.
		 */
		public static final Type FOCUS_IN = new Type(1, "FOCUS_IN");

		/**
		 * This event indicates that the source has lost focus now.
		 */	
		public static final Type FOCUS_OUT = new Type(2, "FOCUS_OUT");
	}

	
	/**
	 * Construct a FocusEvent object.
	 */
	public FocusEvent(Object source, FocusEvent.Type type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(FocusEvent.Type aType){
		return ( type.getID() == aType.getID());
	}
}
