/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * An event represeting action by a {@link org.gnu.gtk.UIManager} object.
 * @see UIManagerListener
 * @see org.gnu.gtk.UIManager
 */
public class UIManagerEvent extends GtkEvent {

	public static class Type extends GtkEventType {
	    private Type(int id, String name){
		super(id, name);
	    }

	    public static final Type ADD_WIDGET = new Type(1, "ADD_WIDGET");
	
	    public static final Type ACTIONS_CHANGED = new Type(2, "ACTIONS_CHANGED");

	    public static final Type CONNECT_PROXY = new Type(3, "CONNECT_PROXY");
	    
	    public static final Type DISCONNECT_PROXY = new Type(4, "DISCONNECT_PROXY");
	    
	    public static final Type PRE_ACTIVATE = new Type(5, "PRE_ACTIVATE");
	    
	    public static final Type POST_ACTIVATE = new Type(6, "POST_ACTIVATE");
	}

	/**
	 * Construct a UIManagerEvent object.
	 */
	public UIManagerEvent(Object source, GtkEventType type) {
		super(source, type);
	}

	/**
	 * @return True if the type of this event is the same as that stated.
	 */
	public boolean isOfType(UIManagerEvent.Type aType) {
		return (type.getID() == aType.getID());
	}
}
