/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * The PangoRectangle structure represents a rectangle. It is frequently used to
 * represent the logical or ink extents of a single glyph or section of text.
 */
public class Rectangle extends Boxed 
{

	protected Rectangle(Handle handle){
		this.handle = handle;
	}

	/**
	 * Returns X coordinate of the left side of the rectangle.
	 */
	public int getX(){
		return getX(handle);
	}

	/**
	 * Returns Y coordinate of the the top side of the rectangle.
	 */
	public int getY(){
		return getY(handle);
	}

	/**
	 * Returns width of the rectangle.
	 */
	public int getWidth(){
		return getWidth(handle);
	}

	/**
	 * Returns height of the rectangle.
	 */
	public int getHeight(){
		return getHeight(handle);
}	
		
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getX (Handle obj);
    native static final protected int getY (Handle obj);
    native static final protected int getWidth (Handle obj);
    native static final protected int getHeight (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

