/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * This is a MenuItem that displays an Image.
 */
public class ImageMenuItem extends MenuItem 
{
	/**
	 * Construct a new ImageMenuItem.
	 */
	public ImageMenuItem() {
		super(gtk_image_menu_item_new());
	}
	
	/**
	 * Construct a new ImageMenuItem with a label.
	 */
	public ImageMenuItem(String label, boolean hasMnemonic) {
		super(init(label, hasMnemonic));
	}
	
	private static Handle init(String label, boolean hasMnemonic) {
		if (hasMnemonic)
			return gtk_image_menu_item_new_with_mnemonic(label);
		else
			return gtk_image_menu_item_new_with_label(label);
	}
	
	/**
	 * Construct a new ImageMenuItem using a stock icon.
	 */
	public ImageMenuItem(String stockID, AccelGroup group) {
		super(gtk_image_menu_item_new_from_stock(stockID, group.getHandle()));
	}
	
	/**
	 * Construct a ImageMenuItem using a handle to a native resource.
	 */
	public ImageMenuItem(Handle handle) {
		super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_image_menu_item_get_type());
	}
	
	public void setImage(Image image) {
	    gtk_image_menu_item_set_image(getHandle(), image.getHandle());
	}
	
	public Image getImage() {
	    Handle hndl = gtk_image_menu_item_get_image(getHandle());
	    if (hndl == null)
	        return null;
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
	        return (Image)obj;
	    return new Image(hndl);
	}


    native static final protected int gtk_image_menu_item_get_type ();
    native static final protected Handle gtk_image_menu_item_new ();
    native static final protected Handle gtk_image_menu_item_new_with_label (String label);
    native static final protected Handle gtk_image_menu_item_new_with_mnemonic (String label);
    native static final protected Handle gtk_image_menu_item_new_from_stock (String stockId, Handle accelGroup);
    native static final protected void gtk_image_menu_item_set_image (Handle image_menu_item, Handle image);
    native static final protected Handle gtk_image_menu_item_get_image (Handle image_menu_item);

}

