/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif


GdkEventType GdkEventMotion_get_type (GdkEventMotion * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventMotion_getType (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventMotion_get_type (obj_g));
}

GdkWindow * GdkEventMotion_get_window (GdkEventMotion * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventMotion_getWindow (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventMotion_get_window (obj_g));
}

gboolean GdkEventMotion_get_send_event (GdkEventMotion * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventMotion_getSendEvent (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventMotion_get_send_event (obj_g));
}

time_t GdkEventMotion_get_time (GdkEventMotion * cptr) 
{
    return cptr->time;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getTime
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventMotion_getTime (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return GdkEventMotion_get_time (obj_g);
}

gdouble GdkEventMotion_get_x (GdkEventMotion * cptr) 
{
    return cptr->x;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getX
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventMotion_getX (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventMotion_get_x (obj_g));
}

gdouble GdkEventMotion_get_y (GdkEventMotion * cptr) 
{
    return cptr->y;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getY
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventMotion_getY (JNIEnv *env, jclass cls, jobject obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventMotion_get_y (obj_g));
}

guint32 GdkEventMotion_get_state (GdkEventMotion * cptr) 
{
    return cptr->state;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventMotion_getState (JNIEnv *env, jclass cls, jobject obj)
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventMotion_get_state (obj_g));
}

gint32 GdkEventMotion_get_is_hint (GdkEventMotion * cptr) 
{
    return cptr->is_hint;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getIsHint
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventMotion_getIsHint (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventMotion_get_is_hint (obj_g));
}

GdkDevice * GdkEventMotion_get_device (GdkEventMotion * cptr) 
{
    return cptr->device;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getDevice
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventMotion_getDevice (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventMotion_get_device (obj_g));
}

gdouble GdkEventMotion_get_x_root (GdkEventMotion * cptr) 
{
    return cptr->x_root;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getXRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventMotion_getXRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventMotion_get_x_root (obj_g));
}

gdouble GdkEventMotion_get_y_root (GdkEventMotion * cptr) 
{
    return cptr->y_root;
}

/*
 * Class:     org.gnu.gdk.EventMotion
 * Method:    getYRoot
 */
JNIEXPORT jdouble JNICALL Java_org_gnu_gdk_EventMotion_getYRoot (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventMotion *obj_g = (GdkEventMotion *)getPointerFromHandle(env, obj);
    return (jdouble) (GdkEventMotion_get_y_root (obj_g));
}


#ifdef __cplusplus
}

#endif
