/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
/**
 *
 */
public class EventExpose extends Boxed 
{
	public EventExpose(Handle handle) {
		this.handle = handle;
	}

	public Window getWindow() {
		return new Window(getWindow(handle));
	}

	public boolean getSendEvent() {
		return getSendEvent(handle);
	}

	public Rectangle getArea() {
		return new Rectangle(getArea(handle));
	}

	public Region getRegion() {
		return new Region(getRegion(handle));
	}

	public int getCount() {
		return getCount(handle);
	}


    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (int obj);
    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected Handle getRegion (Handle obj);
    native static final protected int getCount (Handle obj);
    native static final protected Handle getArea (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}
