/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

/**
 * Represents a rectangle with x, y, width and height members.
 */
package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.GObject;
import org.gnu.glib.Handle;
public class Rectangle extends Boxed 
{
	
	public Rectangle(Handle handle){
		this.handle=handle;
	}
	
    /**
     * Retrieve the x coordinate for the Rectangle.
     */
	public int getX(){
		return Rectangle.getX(handle);
	}
	
    /**
     * Set the x coordinate for the Rectangle.
     * @param x
     */
	public void setX(int x){
		setX(handle,x);		
	}
	
    /**
     * Retrieve the y coordinate for the Rectangle.
     */
	public int getY(){
		return Rectangle.getY(handle);
	}
	
    /**
     * Set the y coordinate for the Rectangle.
     * @param y
     */
	public void setY(int y){
		setY(handle,y);
	}
	
    /**
     * Retrieve the width of the Rectangle.
     */
	public int getWidth(){
		return Rectangle.getWidth(handle);
	}
	
    /**
     * Set the width of the Rectangle.
     * @param width
     */
	public void setWidth(int width){
		setWidth(handle,width);
	}
	
    /**
     * Retrieve the height of the Rectangle.
     */
	public int getHeight(){
		return Rectangle.getHeight(handle);
	}
	
    /**
     * Set the height of the Rectangle.
     * @param heigth
     */
	public void setHeight(int heigth){
		setHeight(handle,heigth);
	}
	
	/**
     * Returns the intersection of this Rectangle and the provided Rectangle or
     * null if there is no intersection. 
     * @param rect
	 */
	public Rectangle intersect(Rectangle rect){
        Handle intersect = GObject.getNullHandle();
		boolean val = gdk_rectangle_intersect(getHandle(), rect.getHandle(), intersect);
        if (val)
            return new Rectangle(intersect);
		return null;
	}
	
	/**
     * Returns the union of this Rectangle and the provided Rectangle or
     * null if there is no union.
     * @param rect
	 */
	public Rectangle union(Rectangle rect){
        Handle union = GObject.getNullHandle();
        gdk_rectangle_union(getHandle(), rect.getHandle(), union);
		if (union.isNull())
            return null;
        return new Rectangle(union);
	}
	
    protected void finalize() throws Throwable {
        super.finalize();
        free(getHandle());
    }
    
    
    native static final protected int getX (Handle obj);
    native final protected void setX (Handle obj, int x);
    native static final protected int getY (Handle obj);
    native final protected void setY (Handle obj, int y);
    native static final protected int getWidth (Handle obj);
    native final protected void setWidth (Handle obj, int width);
    native static final protected int getHeight (Handle obj);
    native final protected void setHeight (Handle obj, int height);
    native static final protected boolean gdk_rectangle_intersect (Handle src1, Handle src2, Handle dest);
    native static final protected void gdk_rectangle_union (Handle src1, Handle src2, Handle dest);
    native static final protected void free(Handle obj);
}

