/*
This file is licensed to you under the license specified in the included file
`LICENSE'. Look there for further details.
*/


#ifndef _GENGETOPT_GGOS_H
#define _GENGETOPT_GGOS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <list>
#include <iostream>

#include "acceptedvalues.h"

struct gengetopt_option
{
  char short_opt;
  char * long_opt;
  char * desc;
  int type; /* values in `argsdef.h' */
  int flagstat ;
  int required;
  char * var_arg; /* canonized long_opt + "_arg" = argument var */
  int default_given ; /* if a default is given */
  char * default_string ; /* default value for this option, if string */
  char * group_value; /* group name, if it's part of an option group */
  char * group_desc; /* group description, if it's part of an option group */
  bool multiple; /* whether this option can be given more than once */
  bool arg_is_optional; /* whether the argument is optional */
  char *type_str; /* Alternative name for type,
                     e.g. "URL" or "SECONDS" */
  const AcceptedValues *acceptedvalues; /* values that can be passed to this option */
  char *section; /* the section of this option */
  char *section_desc; /* the description associated with the possible section */
};

typedef std::list<gengetopt_option *> gengetopt_option_list;

std::ostream & operator <<(std::ostream &s, gengetopt_option &opt);

#endif /* _GENGETOPT_GGOS_H */
