# configuration for compiling with g++

#
# Adjustable parameters
#

# This tells us where to find the X libraries.

J_X11_LIB_DIR := -L/usr/X11R6/lib

# Uncomment this and change it if your X11 headers are not in /usr/include/X11.

# J_X11_INCLUDE_DIR := -I/usr/include

# Uncomment this if you want to compile libXpm into libjx

# JX_INCLUDE_LIBXPM := yes

# This sets the optimization level

J_OPTIMIZE_LEVEL := 0

# Comment this out if your system is not ELF.

J_BUILD_SHARED_LIB := -fPIC

# This flag tells the linker to build a shared library.

J_SHARED_LIB_LINK_OPTION := -shared

# Uncomment this if you want debugging versions of the libraries.

# J_COMPILE_DEBUG := -g

ifeq ($(strip $(filter-out jafl glenn laurence, $(USER))),)
  J_COMPILE_DEBUG := -g
endif

# Comment this out if ACE or other code gives you warnings that
# you can't avoid.

J_DIE_ON_WARNING := -Werror

# Uncomment this if istrstream is broken.  One way to check is to run
# testjcore/testJFileArray.

# J_ISTRSTREAM_BROKEN := -D_J_ISTRSTREAM_BROKEN

# Comment this out if new[] and delete[] are not overridable.

J_ARRAY_NEW_OVERRIDABLE := -D_J_ARRAY_NEW_OVERRIDABLE

# Uncomment this if your version of GNU make does not automatically
# generate the -o parameter.

# J_MAKE_NEEDS_OUTPUT_ARG = -o $@

# This command is used to strip debugging info but not the symbol table.

J_STRIP_DEBUG := strip -g

# Comment this out if your version of "ar" does not accept the -s option.

J_RANLIB_VIA_AR_S := -D_J_RANLIB_VIA_AR_S

# Uncomment this if your system doesn't have memmove() (used by jlib/regex)

# J_REGEX_USE_BCOPY := -DUSEBCOPY

# Adjust these until everything compiles

J_RAW_SYSTEM_STUFF := \
  -DSIZEOF_LONG=4 -DSIZEOF_INT=4 \
  -D_LOOSE_KERNEL_NAMES \
  -D_XOPEN_SOURCE -D_XOPEN_SOURCE_EXTENDED \
  -D_BSD_SOURCE -D_GNU_SOURCE

#
# Nothing below this line should ever need to be changed.
#

ifeq ($(strip $(filter-out jafl, $(USER))),)
#  J_HAS_GIF := -D_J_HAS_GIF
#  J_HAS_PNG := -D_J_HAS_PNG	# requires -lpng at front of J_GCC_LIBS
endif

include ${JX_ROOT}/include/make/jx_config_common

# for use in DEPENDFLAGS
# (-Wno-return-type keeps memory usage down when compiling templates)

J_COMPILER_DEPEND_FLAGS_FOR_BISON := \
  -Wall -Wno-unused -Wno-return-type \
  -fno-implicit-templates -fno-rtti \
  -O${J_OPTIMIZE_LEVEL} \
  -D_J_UNIX -D_J_LINUX_INTEL ${J_ISTRSTREAM_BROKEN} \
  ${J_ARRAY_NEW_OVERRIDABLE} ${J_HAS_GIF} ${J_HAS_PNG} \
  ${J_RAW_SYSTEM_STUFF}

J_COMPILER_DEPEND_FLAGS := \
  ${J_COMPILER_DEPEND_FLAGS_FOR_BISON} ${J_DIE_ON_WARNING}

# makemake variables

LINKER := g++

# make variables

CC       := gcc
CXX      := g++
CPPFLAGS  = ${DEPENDFLAGS}
CFLAGS    = ${J_MAKE_NEEDS_OUTPUT_ARG}
CXXFLAGS  = ${J_MAKE_NEEDS_OUTPUT_ARG}

# libraries to link

J_GCC_LIBS  := -lstdc++ -lm -lc -ldl
J_ACE_LIBS  := -L${JX_ROOT}/lib -lACE-${ACE_LIB_VERSION}
J_X11_LIBS  := -L${JX_ROOT}/lib ${J_X11_LIB_DIR} -lXext -lXpm -lX11
J_MESA_LIBS := -L${JX_ROOT}/lib -lMesaGLU -lMesaGL
J_SYS_LIBS  := ${J_ACE_LIBS} ${J_X11_LIBS} ${J_GCC_LIBS}
