/******************************************************************************
 JIPCError.h

	Declarations for JIPCError.

	Copyright  1997 by Dustin Laurence. All rights reserved.

	* The JUnixSocketExists() function overlaps with FileExists(), should they
	all go together?

 *****************************************************************************/

#ifndef _H_JIPCError
#define _H_JIPCError

#include <JError.h>

	extern const JCharacter* kJUnknownHost;
	extern const JCharacter* kJUnknownHostMsg;
	class JUnknownHost : public JError
	{
	public:

		JUnknownHost()
			:
			JError(kJUnknownHost, kJUnknownHostMsg)
			{ };
	};


	extern const JCharacter* kJNoIPAddress;
	extern const JCharacter* kJNoIPAddressMsg;
	class JNoIPAddress : public JError
	{
	public:

		JNoIPAddress()
			:
			JError(kJNoIPAddress, kJNoIPAddressMsg)
			{ };
	};


	extern const JCharacter* kJTemporaryNameserver;
	extern const JCharacter* kJTemporaryNameserverMsg;
	class JTemporaryNameserver : public JError
	{
	public:

		JTemporaryNameserver()
			:
			JError(kJTemporaryNameserver, kJTemporaryNameserverMsg)
			{ };
	};


	extern const JCharacter* kJFatalNameserver;
	extern const JCharacter* kJFatalNameserverMsg;
	class JFatalNameserver : public JError
	{
	public:

		JFatalNameserver()
			:
			JError(kJFatalNameserver, kJFatalNameserverMsg)
			{ };
	};


	extern const JCharacter* kJConnectError;
	extern const JCharacter* kJConnectErrorMsg;
	class JConnectError : public JError
	{
	public:

		JConnectError()
			:
			JError(kJConnectError, kJConnectErrorMsg)
			{ };
	};


	extern const JCharacter* kJNotASocket;
	extern const JCharacter* kJNotASocketMsg;
	class JNotASocket : public JError
	{
	public:

		JNotASocket()
			:
			JError(kJNotASocket, kJNotASocketMsg)
			{ };
	};


	extern const JCharacter* kJSocketCannotListen;
	extern const JCharacter* kJSocketCannotListenMsg;
	class JSocketCannotListen : public JError
	{
	public:

		JSocketCannotListen()
			:
			JError(kJSocketCannotListen, kJSocketCannotListenMsg)
			{ };
	};


	extern const JCharacter* kJSocketCannotAccept;
	extern const JCharacter* kJSocketCannotAcceptMsg;
	class JSocketCannotAccept : public JError
	{
	public:

		JSocketCannotAccept()
			:
			JError(kJSocketCannotAccept, kJSocketCannotAcceptMsg)
			{ };
	};


	extern const JCharacter* kJSocketClosed;
	extern const JCharacter* kJSocketClosedMsg;
	class JSocketClosed : public JError
	{
	public:

		JSocketClosed()
			:
			JError(kJSocketClosed, kJSocketClosedMsg)
			{ };
	};


	extern const JCharacter* kJAddressInUse;
	extern const JCharacter* kJAddressInUseMsg;
	class JAddressInUse : public JError
	{
	public:

		JAddressInUse()
			:
			JError(kJAddressInUse, kJAddressInUseMsg)
			{ };
	};


	extern const JCharacter* kJSocketAlreadyBound;
	extern const JCharacter* kJSocketAlreadyBoundMsg;
	class JSocketAlreadyBound : public JError
	{
	public:

		JSocketAlreadyBound()
			:
			JError(kJSocketAlreadyBound, kJSocketAlreadyBoundMsg)
			{ };
	};


	extern const JCharacter* kJProtectedAddress;
	extern const JCharacter* kJProtectedAddressMsg;
	class JProtectedAddress : public JError
	{
	public:

		JProtectedAddress()
			:
			JError(kJProtectedAddress, kJProtectedAddressMsg)
			{ };
	};


	extern const JCharacter* kJSocketDoesNotExist;
	extern const JCharacter* kJSocketDoesNotExistMsg;
	class JSocketDoesNotExist : public JError
	{
	public:

		JSocketDoesNotExist()
			:
			JError(kJSocketDoesNotExist, kJSocketDoesNotExistMsg)
			{ };
	};


#endif
