/******************************************************************************
 JOutPipeStream.cc

	This class provides an ostream interface to the write end of a pipe.

	BASE CLASS = ostream

	Copyright  1998 by John Lindal. All rights reserved.

 *****************************************************************************/

#include <JOutPipeStream.h>
#include <jStreamUtil.h>
#include <unistd.h>
#include <jErrno.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 *****************************************************************************/

JOutPipeStream::JOutPipeStream
	(
	const int		fd,
	const JBoolean	close
	)
	:
	ios(&itsBuffer),
	ostream(&itsBuffer),
	itsBuffer(fdopen(fd, "w")),
	itsDescriptor(fd),
	itsCloseFlag(close)
{
}

/******************************************************************************
 Destructor

 *****************************************************************************/

JOutPipeStream::~JOutPipeStream()
{
	close();
}

/******************************************************************************
 close

	This only closes the underlying file descriptor if itsCloseFlag is set.

 *****************************************************************************/

void
JOutPipeStream::close()
{
	if (!bad())
		{
		flush();

		if (itsCloseFlag && ::close(itsDescriptor) != 0)
			{
			cerr << "JOutPipeStream failed to close pipe: " << jerrno() << endl;
			}

		JSetState(*this, badbit);
		}
}
