/******************************************************************************
 JPrefObject.h

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JPrefObject
#define _H_JPrefObject

#include <JPrefsManager.h>	// need definition of JPrefID

class JPrefObject
{
public:

	JPrefObject(JPrefsManager* prefsMgr, const JPrefID& id);

	virtual ~JPrefObject();

	JPrefsManager*	GetPrefsManager() const;
	JIndex			GetID() const;

	void	ReadPrefs();
	void	WritePrefs() const;

protected:

	void	SetPrefsManager(JPrefsManager* prefsMgr);

	// override only in leaf classes

	virtual void	ReadPrefs(istream& input) = 0;
	virtual void	WritePrefs(ostream& output) const = 0;

private:

	JPrefsManager*	itsPrefsMgr;	// not owned
	const JPrefID	itsID;

private:

	// not allowed

	JPrefObject(const JPrefObject& source);
	const JPrefObject& operator=(const JPrefObject& source);
};


/******************************************************************************
 GetPrefsManager

 ******************************************************************************/

inline JPrefsManager*
JPrefObject::GetPrefsManager()
	const
{
	return itsPrefsMgr;
}

inline void
JPrefObject::SetPrefsManager
	(
	JPrefsManager* prefsMgr
	)
{
	itsPrefsMgr = prefsMgr;
}

/******************************************************************************
 GetID

 ******************************************************************************/

inline JIndex
JPrefObject::GetID()
	const
{
	return itsID.GetID();
}

#endif
