/******************************************************************************
 JUNIXPrefsManager.h

	Interface for the JUNIXPrefsManager class

	Copyright  1997 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JUNIXPrefsManager
#define _H_JUNIXPrefsManager

#include <JPrefsManager.h>

class JUNIXPrefsManager : public JPrefsManager
{
public:

	JUNIXPrefsManager(const JCharacter* fileName, const JFileVersion currentVersion,
					  const JBoolean eraseFileIfOpen);

	virtual ~JUNIXPrefsManager();

protected:

	virtual JError	CreateFile(const JCharacter* fileName, JPrefsFile** file) const;
	virtual JError	DeleteFile(const JCharacter* fileName) const;

private:

	// not allowed

	JUNIXPrefsManager(const JUNIXPrefsManager& source);
	JUNIXPrefsManager& operator=(const JUNIXPrefsManager& source);
};

#endif
