/******************************************************************************
 JNew.cc

	JNew.cc defines the JCore operator new, JNew.  JNew provides many memory
	management features that the built-in allocator does not, principally for
	detection of memory leaks.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

//Debug only
//#include <iostream.h>

#include <JMemoryManager.h>

// Module header
#include <jNew.h>
#undef new
#undef delete

/******************************************************************************
 operator new

 *****************************************************************************/

void*
operator new
	(
	size_t size
	)
	#ifdef __KCC
	MSIPL_THROW_STR(std::bad_alloc)
	#endif
{
	return operator new(size, "<UNKNOWN>", 0);
}

/******************************************************************************
 operator new

 *****************************************************************************/

void*
operator new
	(
	size_t             size,
	const  JCharacter* file,
	const  JUInt32     line
	)
{
	return JMemoryManager::New(size, file, line, kFalse);
}

/******************************************************************************
 operator new[]

 *****************************************************************************/

void*
operator new[]
	(
	size_t size
	)
	#ifdef __KCC
	MSIPL_THROW_STR(std::bad_alloc)
	#endif
{
	return operator new[](size, "<UNKNOWN>", 0);
}

/******************************************************************************
 operator new[]

 *****************************************************************************/

void*
operator new[]
	(
	size_t             size,
	const  JCharacter* file,
	const  JUInt32     line
	)
{
	return JMemoryManager::New(size, file, line, kTrue);
}

/******************************************************************************
 operator delete

 *****************************************************************************/

void
operator delete
	(
	void* memory
	)
	#ifdef __KCC
	MSIPL_THROW_STR()
	#endif
{
	JMemoryManager::Instance()->Delete(memory, kFalse);
}

/******************************************************************************
 operator delete[]

 *****************************************************************************/

void
operator delete[]
	(
	void* memory
	)
	#ifdef __KCC
	MSIPL_THROW_STR()
	#endif
{
	JMemoryManager::Instance()->Delete(memory, kTrue);
}

/******************************************************************************
 LocateDelete

 *****************************************************************************/

void
LocateDelete
	(
	const JCharacter* file,
	const JUInt32     line
	)
{
	JMemoryManager::Instance()->LocateDelete(file, line);
}
