/******************************************************************************
 jStrStreamUtil.h

	Interface for jStrStreamUtil.cc

	Copyright  1994 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_jStrStreamUtil
#define _H_jStrStreamUtil

#include <strstream.h>
#include <jTypes.h>

/******************************************************************************
 jistrstream

	Macro to create a working istrstream object.  istrstream is broken
	on some systems, so strstream is used instead.

 ******************************************************************************/

#ifdef _J_ISTRSTREAM_BROKEN

#define jistrstream(objName, str, length) \
		strstream objName(const_cast<JCharacter*>(str), length, ios::in)

#elif defined __VCPP__

#define jistrstream(objName, str, length) \
		istrstream objName(const_cast<JCharacter*>(str), length)

#else

#define jistrstream(objName, str, length) \
		istrstream objName(str, length)

#endif

/******************************************************************************
 JUnfreeze

	Convenience function to unfreeze an ostrstream after using str().

 ******************************************************************************/

inline void
JUnfreeze
	(
	ostrstream&	s
	)
{
	#ifdef __KCC
	s.freeze(0);
	#else
	(s.rdbuf())->freeze(0);
	#endif
}

#endif
