/******************************************************************************
 JXChooseFileDialog.h

	Interface for the JXChooseFileDialog class

	Copyright  1996-98 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXChooseFileDialog
#define _H_JXChooseFileDialog

#include <JXCSFDialogBase.h>

class JXChooseFileDialog : public JXCSFDialogBase
{
public:

	JXChooseFileDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
					   const JCharacter* fileFilter, const JBoolean allowSelectMultiple);

	virtual ~JXChooseFileDialog();

	void	BuildWindow(const JCharacter* origName, const JCharacter* message);

	JBoolean	GetFullName(JString* fullName) const;
	JBoolean	GetFullNames(JPtrArray<JString>* fullNameList) const;

protected:

	void	SetObjects(JXScrollbarSet* scrollbarSet,
					   JXStaticText* pathLabel, JXPathInput* pathInput,
					   JXPathHistoryMenu* pathHistory,
					   JXStaticText* filterLabel, JXInputField* filterInput,
					   JXStringHistoryMenu* filterHistory,
					   JXTextButton* openButton, JXTextButton* cancelButton,
					   JXTextButton* upButton, JXTextButton* homeButton,
					   JXTextButton* selectAllButton, JXTextCheckbox* showHiddenCB,
					   const JCharacter* origName, const JCharacter* message);

	virtual void	AdjustSizings();
	virtual void	UpdateDisplay();

	virtual JBoolean	OKToDeactivate();
	virtual void		Receive(JBroadcaster* sender, const Message& message);

private:

	const JBoolean	itsSelectMultipleFlag;

// begin JXLayout

    JXTextButton* itsOpenButton;
    JXTextButton* itsSelectAllButton;

// end JXLayout

private:

	// not allowed

	JXChooseFileDialog(const JXChooseFileDialog& source);
	const JXChooseFileDialog& operator=(const JXChooseFileDialog& source);
};

#endif
