/******************************************************************************
 JXMenuManager.h

	Interface for JXMenuManager class.

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXMenuManager
#define _H_JXMenuManager

#include <JPtrArray.h>

class JXMenu;

class JXMenuManager
{
	friend class JXMenu;

public:

	JXMenuManager();

	virtual ~JXMenuManager();

	void	CloseCurrentMenus();

private:

	JPtrArray<JXMenu>*	itsOpenMenuList;	// we don't own the menus

private:

	// called by JXMenu

	void	MenuOpened(JXMenu* menu);
	void	MenuClosed(JXMenu* menu);

	// not allowed

	JXMenuManager(const JXMenuManager& source);
	const JXMenuManager& operator=(const JXMenuManager& source);
};


/******************************************************************************
 MenuOpened (private)

 ******************************************************************************/

inline void
JXMenuManager::MenuOpened
	(
	JXMenu* menu
	)
{
	if (!itsOpenMenuList->Includes(menu))
		{
		itsOpenMenuList->Append(menu);
		}
}

/******************************************************************************
 MenuClosed (private)

 ******************************************************************************/

inline void
JXMenuManager::MenuClosed
	(
	JXMenu* menu
	)
{
	itsOpenMenuList->Remove(menu);
}

#endif
