/******************************************************************************
 JXSaveFileInput.h

	Interface for the JXSaveFileInput class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXSaveFileInput
#define _H_JXSaveFileInput

#include <JXInputField.h>

class JXSaveFileInput : public JXInputField
{
public:

	JXSaveFileInput(JXContainer* enclosure,
					const HSizingOption hSizing, const VSizingOption vSizing,
					const JCoordinate x, const JCoordinate y,
					const JCoordinate w, const JCoordinate h);

	virtual ~JXSaveFileInput();

	virtual void	HandleKeyPress(const int key, const JXKeyModifiers& modifiers);

protected:

	virtual void	HandleFocusEvent();
	virtual JError	FilterSelectionData(JString* text, JRunArray<Font>* style) const;

private:

	// not allowed

	JXSaveFileInput(const JXSaveFileInput& source);
	const JXSaveFileInput& operator=(const JXSaveFileInput& source);
};

#endif
