/******************************************************************************
 JXStyleTableMenu.h

	Interface for the JXStyleTableMenu class

	Copyright  1997 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXStyleTableMenu
#define _H_JXStyleTableMenu

#include <JXStyleMenu.h>

class JXStyleTable;

class JXStyleTableMenu : public JXStyleMenu
{
public:

	static JXStyleTableMenu*	Create(JXStyleTable* table, const JXMenu::Style menuStyle,
										 JXContainer* enclosure,
										 const HSizingOption hSizing, const VSizingOption vSizing,
										 const JCoordinate x, const JCoordinate y,
										 const JCoordinate w, const JCoordinate h);

	static JXStyleTableMenu*	Create(JXStyleTable* table, const JXMenu::Style menuStyle,
										 JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	virtual ~JXStyleTableMenu();

protected:

	JXStyleTableMenu(JXStyleTable* table, const JXMenu::Style menuStyle,
					 JXContainer* enclosure,
					 const HSizingOption hSizing, const VSizingOption vSizing,
					 const JCoordinate x, const JCoordinate y,
					 const JCoordinate w, const JCoordinate h);

	JXStyleTableMenu(JXStyleTable* table, const JXMenu::Style menuStyle,
					 JXMenu* owner, const JIndex itemIndex, JXContainer* enclosure);

	virtual void		UpdateMenu();
	virtual JFontStyle	GetFontStyleForMenuUpdate() const;
	virtual void		HandleMenuItem(const JIndex menuItem);

private:

	JXStyleTable*	itsTable;		// we don't own this

private:

	// not allowed

	JXStyleTableMenu(const JXStyleTableMenu& source);
	const JXStyleTableMenu& operator=(const JXStyleTableMenu& source);
};

#endif
