/******************************************************************************
 JXTextClipboard.cc

	Since X uses lazy evaluation, one normally loses the contents of the
	clipboard when the clipboard owner is deleted.  This class allows one
	to preserve text on the clipboard by simply calling SetClipboard() with
	the text or UpdateClipboard() after every Copy().  (JXTEBase does
	this automatically.)

	BASE CLASS = JXTEBase

	Copyright  1997-99 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXTextClipboard.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXTextClipboard::JXTextClipboard
	(
	JXContainer* enclosure
	)
	:
	JXTEBase(kSelectableText, kTrue, kTrue, NULL,
			 enclosure, kFixedLeft, kFixedTop, 0,0, 10,10)
{
	Hide();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXTextClipboard::~JXTextClipboard()
{
}

/******************************************************************************
 GrabClipboard (private)

 ******************************************************************************/

JBoolean
JXTextClipboard::GrabClipboard()
{
	if (!IsEmpty())
		{
		SelectAll();
		Copy();					// grab ownership of the clipboard
		DeleteSelection();		// we only need to store the data in itsTextClip
		ClearUndo();			// we don't need undo
		return kTrue;
		}
	else
		{
		return kFalse;
		}
}
