/******************************************************************************
 AboutDialog.cc

	BASE CLASS = JXDialogDirector

	Written by John Lindal.

 ******************************************************************************/

#include "AboutDialog.h"
#include <JXWindow.h>
#include <JXTextButton.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

AboutDialog::AboutDialog
	(
	JXDirector* supervisor
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow();
}

/******************************************************************************
 Destructor

 ******************************************************************************/

AboutDialog::~AboutDialog()
{
}

/******************************************************************************
 BuildWindow (private)

 ******************************************************************************/

void
AboutDialog::BuildWindow()
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 100,100, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* okButton =
        new JXTextButton("Gee, thanks!", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,35, 80,30);
    assert( okButton != NULL );
    okButton->SetShortcuts("t!^[");
    okButton->SetFontSize(10);

// end JXLayout

	window->SetTitle("About this silly program");
	SetButtons(okButton, NULL);
}
