/******************************************************************************
 AnimateWindowIconTask.cc

	BASE CLASS = JXIdleTask

	Written by John Lindal.

 ******************************************************************************/

#include "AnimateWindowIconTask.h"
#include "WindowIconBitmaps.h"
#include <JXDisplay.h>
#include <JXWindow.h>
#include <JXImageMask.h>
#include <JXColormap.h>
#include <JKLRand.h>
#include <jAssert.h>

const JSize kSillyIconPeriod = 500;		// 0.5 seconds (milliseconds)

/******************************************************************************
 Constructor

 ******************************************************************************/

AnimateWindowIconTask::AnimateWindowIconTask
	(
	JXWindow* window
	)
	:
	JXIdleTask(0),
	itsRNG()
{
	itsWindow = window;
	itsState  = kNormalIconState;

	SetPeriod(itsRNG.UniformULong(5,15) * 1000);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

AnimateWindowIconTask::~AnimateWindowIconTask()
{
	if (itsState == kSillyIconState)
		{
		DisplayNormalIcon();
		}
}

/******************************************************************************
 Perform

 ******************************************************************************/

void
AnimateWindowIconTask::Perform
	(
	const Time	delta,
	Time*		maxSleepTime
	)
{
	const JBoolean perform = TimeToPerform(delta, maxSleepTime);
	if (perform && itsState == kNormalIconState)
		{
		DisplaySillyIcon();
		SetPeriod(kSillyIconPeriod);
		}
	else if (perform && itsState == kSillyIconState)
		{
		DisplayNormalIcon();
		SetPeriod(itsRNG.UniformULong(5,15) * 1000);
		}
}

/******************************************************************************
 DisplayNormalIcon

 ******************************************************************************/

void
AnimateWindowIconTask::DisplayNormalIcon()
{
	itsState = kNormalIconState;

	JXDisplay* display   = itsWindow->GetDisplay();
	JXColormap* colormap = display->GetColormap();

	JXImageMask* mask = new JXImageMask(display, colormap, kWindowIconMask);
	assert( mask != NULL );

	JXImage icon(display, colormap, kWindowIcon, colormap->GetBlueColor());
	icon.SetMask(mask);

	itsWindow->SetIcon(icon);
}

/******************************************************************************
 DisplaySillyIcon

 ******************************************************************************/

void
AnimateWindowIconTask::DisplaySillyIcon()
{
	itsState = kSillyIconState;

	JXDisplay* display   = itsWindow->GetDisplay();
	JXColormap* colormap = display->GetColormap();

	JXImageMask* mask = new JXImageMask(display, colormap, kWindowIcon2Mask);
	assert( mask != NULL );

	JXImage icon(display, colormap, kWindowIcon2, colormap->GetBlueColor());
	icon.SetMask(mask);

	itsWindow->SetIcon(icon);
}
