/******************************************************************************
 SetElasticDialog.cc

	BASE CLASS = JXDialogDirector

	Written by John Lindal.

 ******************************************************************************/

#include "SetElasticDialog.h"

#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXIntegerInput.h>
#include <JXStaticText.h>

#include <JString.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

SetElasticDialog::SetElasticDialog
	(
	JXWindowDirector*	supervisor,
	const JIndex		index,
	const JIndex		maxIndex
	)
	:
	JXDialogDirector(supervisor, kTrue)
{
	BuildWindow(index, maxIndex);
}

/******************************************************************************
 Destructor

 ******************************************************************************/

SetElasticDialog::~SetElasticDialog()
{
}

/******************************************************************************
 BuildWindow (protected)

 ******************************************************************************/

void
SetElasticDialog::BuildWindow
	(
	const JIndex index,
	const JIndex maxIndex
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 200,90, "");
    assert( window != NULL );
    SetWindow(window);

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 20,60, 50,20);
    assert( cancelButton != NULL );

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 109,59, 52,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    itsElasticIndex =
        new JXIntegerInput(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 140,20, 40,20);
    assert( itsElasticIndex != NULL );

    JXStaticText* obj1 =
        new JXStaticText("Elastic compartment:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,20, 130,20);
    assert( obj1 != NULL );

// end JXLayout

	window->SetTitle("Set elastic compartment");
	SetButtons(okButton, cancelButton);

	itsElasticIndex->SetValue(index);
	itsElasticIndex->SetLimits(0, maxIndex);
}

/******************************************************************************
 GetElasticIndex

 ******************************************************************************/

JIndex
SetElasticDialog::GetElasticIndex()
	const
{
	JInteger size;
	const JBoolean ok = itsElasticIndex->GetValue(&size);
	assert( ok );
	return size;
}
