/******************************************************************************
 HelloWorldDir.cc

	BASE CLASS = JXWindowDirector

	Written by Glenn Bach - 1997.

 ******************************************************************************/

#include "HelloWorldDir.h"
#include <JXWindow.h>
#include <JXStaticText.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

HelloWorldDir::HelloWorldDir
	(
	JXDirector* supervisor
	)
	:
	JXWindowDirector(supervisor)
{
	// Create the Hello World window
	JXWindow* window = new JXWindow(this, 200,100, "Hello World Program");

	// Make sure that new succeeded
    assert( window != NULL );

    // Tell the window director that this is its window
    SetWindow(window);

    // Set the min and max size of the window.
    // This particular pair of operations can also be done
    // by calling window->LockCurrentSize().
    window->SetMinSize(200,100);
	window->SetMaxSize(200,100);

	// Create the object to hold our "Hello World" message.
	// We do not need to keep a pointer to it because the
	// framework will delete it automatically when the window
	// is closed.
	JXStaticText* text = 
		new JXStaticText("Hello World", window, 
			JXWidget::kFixedLeft, JXWidget::kFixedTop,
			20, 40, 160, 20);
	assert( text != NULL );
}

/******************************************************************************
 Destructor

 ******************************************************************************/

HelloWorldDir::~HelloWorldDir()
{
}
