/* $Id: BulletinB.h,v 1.1.1.1 2001/04/09 13:31:59 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_bulletinb_h)
#define xarm_bulletinb_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>
#include <Xm/BulletinB.h>

class BulletinBoardClass : public ManagerClass {
 protected:
   BulletinBoardClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmBulletinBoardWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmBulletinBoard"; }
 public:
   /* callbacks */
   void focusCallback(XtCallbackProc fp, XtPointer data = NULL)  { XARM_SET_CALLBACK(XmNfocusCallback); }
   void mapCallback(XtCallbackProc fp, XtPointer data = NULL)    { XARM_SET_CALLBACK(XmNmapCallback); }
   void unmapCallback(XtCallbackProc fp, XtPointer data = NULL)  { XARM_SET_CALLBACK(XmNunmapCallback); }

   /* resources */
   void allowOverlap(Boolean val)       { XARM_SET_VALUE(XmNallowOverlap); }
   Boolean allowOverlap() const         { XARM_GET_VALUE(Boolean, XmNallowOverlap); }
   Boolean autoUnmanage() const         { XARM_GET_VALUE(Boolean, XmNautoUnmanage); }
   void buttonFontList(XmFontList val)  { XARM_SET_VALUE(XmNbuttonFontList); }
   XmFontList buttonFontList() const    { XARM_GET_VALUE(XmFontList, XmNbuttonFontList); }
   void cancelButton(Widget val)        { XARM_SET_VALUE(XmNcancelButton); }
   Widget cancelButton() const          { XARM_GET_VALUE(Widget, XmNcancelButton); }
   void defaultButton(Widget val)       { XARM_SET_VALUE(XmNdefaultButton); }
   Widget defaultButton() const         { XARM_GET_VALUE(Widget, XmNdefaultButton); }
   void defaultPosition(Boolean val)    { XARM_SET_VALUE(XmNdefaultPosition); }
   Boolean defaultPosition() const      { XARM_GET_VALUE(Boolean, XmNdefaultPosition); }
   void dialogStyle(unsigned char val)  { XARM_SET_VALUE(XmNdialogStyle); }
   unsigned char dialogStyle() const    { XARM_GET_VALUE(unsigned char, XmNdialogStyle); }
   void dialogTitle(const char *str)    { XARM_SET_STRING(XmNdialogTitle); }
   char *dialogTitle() const            { XARM_GET_STRING(XmNdialogTitle); }
   void labelFontList(XmFontList val)   { XARM_SET_VALUE(XmNlabelFontList); }
   XmFontList labelFontList() const     { XARM_GET_VALUE(XmFontList, XmNlabelFontList); }
   void marginHeight(Dimension val)     { XARM_SET_VALUE(XmNmarginHeight); } 
   Dimension marginHeight() const       { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)      { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const        { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void noResize(Boolean val)           { XARM_SET_VALUE(XmNnoResize); }
   Boolean noResize() const             { XARM_GET_VALUE(Boolean, XmNnoResize); }
   void resizePolicy(unsigned char val) { XARM_SET_VALUE(XmNresizePolicy); }
   unsigned char resizePolicy() const   { XARM_GET_VALUE(unsigned char, XmNresizePolicy); }
   void shadowType(unsigned char val)   { XARM_SET_VALUE(XmNshadowType); }
   unsigned char shadowType() const     { XARM_GET_VALUE(unsigned char, XmNshadowType); }
   void textFontList(XmFontList val)    { XARM_SET_VALUE(XmNtextFontList); }
   XmFontList textFontList() const      { XARM_GET_VALUE(XmFontList, XmNtextFontList); }

};

typedef XarmRawWidget<BulletinBoardClass, false> BulletinBoard;

#endif
