/* $Id: Core.h,v 1.1.1.1 2001/04/09 13:32:16 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_core_h)
#define xarm_core_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/RectObj.h>
#include <Xarm/XarmArg.h>

class CoreClass : public _RectObjClass {
 protected:
   CoreClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return coreWidgetClass; }
   virtual _XtString className() { return (_XtString) "Core"; }
 public:
   /* resources */
   void accelerators(const XtAccelerators val) { XARM_SET_VALUE(XmNaccelerators); }
   XtAccelerators accelerators() const         { XARM_GET_VALUE(XtAccelerators, XmNaccelerators); }
   void  background(Pixel val)                 { XARM_SET_VALUE(XmNbackground); }
   Pixel background() const                    { XARM_GET_VALUE(Pixel, XmNbackground); }
   void   backgroundPixmap(const Pixmap val)   { XARM_SET_VALUE(XmNbackgroundPixmap); }
   Pixmap backgroundPixmap() const             { XARM_GET_VALUE(Pixmap, XmNbackgroundPixmap); }
   void borderColor(Pixel val)                 { XARM_SET_VALUE(XmNborderColor); }
   Pixel borderColor() const                   { XARM_GET_VALUE(Pixel, XmNborderColor); }
   void borderPixmap(const Pixmap val)         { XARM_SET_VALUE(XmNborderPixmap); }
   Pixmap borderPixmap() const                 { XARM_GET_VALUE(Pixmap, XmNborderPixmap); }
   Colormap colormap() const                   { XARM_GET_VALUE(Colormap, XmNcolormap); }
   int depth() const                           { XARM_GET_VALUE(int, XmNdepth); }
   Boolean mappedWhenManaged() const           { XARM_GET_VALUE(Boolean, XmNmappedWhenManaged); }
   void mappedWhenManaged(Boolean val)         { XARM_SET_VALUE(XmNmappedWhenManaged); }
   Screen *screen() const                      { XARM_GET_VALUE(Screen *, XmNscreen); }
   XtTranslations translations() const         { XARM_GET_VALUE(XtTranslations, XmNtranslations); }
   void translations(const XtTranslations val) { XARM_SET_VALUE(XmNtranslations); }

   /* extra functionality */
   void background(const char *);
   void backgroundPixmap(const char *);
   void borderColor(const char *);

};

#endif
