/* $Id: Frame.h,v 1.1.1.1 2001/04/09 13:32:28 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_frame_h)
#define xarm_frame_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>
#include <Xm/Frame.h>

class FrameClass : public ManagerClass {
 protected:
   FrameClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()  { return xmFrameWidgetClass; }
   virtual _XtString className()       { return (_XtString) "XmFrame"; } 
 public:
   /* resources */
   void marginHeight(Dimension val)    { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const      { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)     { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const       { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void shadowType(unsigned char val)  { XARM_SET_VALUE(XmNshadowType); }
   unsigned char shadowType() const    { XARM_GET_VALUE(unsigned char, XmNshadowType); }
};

typedef XarmRawWidget<FrameClass, false> Frame;

#endif
