/* $Id: LabelG.h,v 1.1.1.1 2001/04/09 13:32:39 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_labelg_h)
#define xarm_labelg_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Gadget.h>
#include <Xm/LabelG.h>

class LabelGadgetClass : public GadgetClass {
 protected:
   LabelGadgetClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()                  { return xmLabelGadgetClass; }
   /* class name */
   virtual _XtString className()                       { return (_XtString) "XmLabelGadget"; }
 public:
   /* resources */
   void accelerator(const _XtString val)               { XARM_SET_VALUE(XmNaccelerator); }
   _XtString accelerator() const                       { XARM_GET_VALUE(_XtString, XmNaccelerator); }
   void acceleratorText(const char *str)               { XARM_SET_STRING(XmNacceleratorText); }
   char *acceleratorText() const                       { XARM_GET_STRING(XmNacceleratorText); }
   void alignment(unsigned char val)                   { XARM_SET_VALUE(XmNalignment); }
   unsigned char alignment() const                     { XARM_GET_VALUE(unsigned char, XmNalignment); }
   void fontList(const XmFontList val)                 { XARM_SET_VALUE(XmNfontList); }
   XmFontList fontList() const                         { XARM_GET_VALUE(XmFontList, XmNfontList); }
   void labelInsensitivePixmap(Pixmap val)             { XARM_SET_VALUE(XmNlabelInsensitivePixmap); }
   Pixmap labelInsensitivePixmap() const               { XARM_GET_VALUE(Pixmap, XmNlabelInsensitivePixmap); }
   void labelPixmap(const Pixmap val)                  { XARM_SET_VALUE(XmNlabelPixmap); }
   Pixmap labelPixmap() const                          { XARM_GET_VALUE(Pixmap, XmNlabelPixmap); }
   void labelString(const char *str)                   { XARM_SET_STRING(XmNlabelString); }
   char *labelString() const                           { XARM_GET_STRING(XmNlabelString); }
   void labelType(unsigned char val)                   { XARM_SET_VALUE(XmNlabelType); }
   unsigned char labelType() const                     { XARM_GET_VALUE(unsigned char, XmNlabelType); }
   void marginBottom(Dimension val)                    { XARM_SET_VALUE(XmNmarginBottom); }
   Dimension marginBottom() const                      { XARM_GET_VALUE(Dimension, XmNmarginBottom); }
   void marginHeight(Dimension val)                    { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const                      { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginLeft(Dimension val)                      { XARM_SET_VALUE(XmNmarginLeft); }
   Dimension marginLeft() const                        { XARM_GET_VALUE(Dimension, XmNmarginLeft); }
   void marginRight(Dimension val)                     { XARM_SET_VALUE(XmNmarginRight); }
   Dimension marginRight() const                       { XARM_GET_VALUE(Dimension, XmNmarginRight); }
   void marginTop(Dimension val)                       { XARM_SET_VALUE(XmNmarginTop); }
   Dimension marginTop() const                         { XARM_GET_VALUE(Dimension, XmNmarginTop); }
   void marginWidth(Dimension val)                     { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const                       { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void mnemonic(const KeySym val)                     { XARM_SET_VALUE(XmNmnemonic); }
   KeySym mnemonic() const                             { XARM_GET_VALUE(KeySym, XmNmnemonic); }
   void mnemonicCharSet(const _XtString val)           { XARM_SET_VALUE(XmNmnemonicCharSet); }
   _XtString mnemonicCharSet() const                   { XARM_GET_VALUE(_XtString, XmNmnemonicCharSet); }
   void recomputeSize(Boolean val)                     { XARM_SET_VALUE(XmNrecomputeSize); }
   Boolean recomputeSize() const                       { XARM_GET_VALUE(Boolean, XmNrecomputeSize); }
   void stringDirection(const XmStringDirection val)   { XARM_SET_VALUE(XmNstringDirection); }
   XmStringDirection stringDirection() const           { XARM_GET_VALUE(XmStringDirection, XmNstringDirection); }
};

//----------------------------------------//
// LabelGadget is not a typedef because   //
// he has non-standard constructors.      //
//----------------------------------------//

class LabelGadget : public LabelGadgetClass {
 public:
   LabelGadget(Widget w_parent, const char *str, _XtString name = NULL);
   LabelGadget(Widget w_parent,
               ArgList arglist = NULL,
               Cardinal cnt = 0,
               _XtString name = NULL);
   LabelGadget(_XtString name, Widget w_parent);
   LabelGadget(Widget w_parent, XarmArg &args, _XtString name);
};


#endif
