/*
 Copyright (C) 1996       Peter Williams
 Copyright (C) 1997, 1999 Gerald L. Gay

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_passwordf_h)
#define xarm_passwordf_h

#include <string>
#include <Xarm/TextF.h>
#include <Xarm/Xarm.h>

class PasswordField : public TextField
{
 private:
   void onModify(Widget, XtPointer, XtPointer);
   void onInit();

#if defined(XARM_HAS_NAMESPACES)
   std::string  passwd;
#else
   string  passwd;
#endif

   char    filler;
   bool    PasteEnabled;
   bool    insideValueFunc;

 public:
   PasswordField(Widget w_parent,
                 ArgList arglist = NULL,
                 Cardinal cnt = 0,
                 _XtString name = NULL);
   PasswordField(_XtString name, Widget w_parent);
   PasswordField(Widget w_parent, XarmArg &args, _XtString name);

   const char *password()   { return passwd.c_str(); }
   void fillChar(char c)    { filler = c; }
   char fillChar() const    { return filler; }
   void enablePaste(bool b) { PasteEnabled = b; }
   bool enablePaste() const { return PasteEnabled; }

   // For compatibility with TextField
   _XtString  value() const;
   void       value(const char *);
};

#endif

