/* $Id: RectObj.h,v 1.1.1.1 2001/04/09 13:33:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_rectobj_h)
#define xarm_rectobj_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Object.h>

class _RectObjClass : public _ObjectClass {
 protected:
   _RectObjClass() {}

   virtual WidgetClass classPointer()  { return rectObjClass; }
   virtual _XtString className()       { return (_XtString) "RectObj"; }
 public:
   /* resources */
   Boolean ancestorSensitive() const   { XARM_GET_VALUE(Boolean, XmNancestorSensitive); }
   void borderWidth(Dimension val)     { XARM_SET_VALUE(XmNborderWidth); }
   Dimension borderWidth() const       { XARM_GET_VALUE(Dimension, XmNborderWidth); }
   Dimension height() const            { XARM_GET_VALUE(Dimension, XmNheight); }
   void height(Dimension val)          { XARM_SET_VALUE(XmNheight); }
   Dimension width() const             { XARM_GET_VALUE(Dimension, XmNwidth); }
   void width(Dimension val)           { XARM_SET_VALUE(XmNwidth); }
   Position x() const                  { XARM_GET_VALUE(Position, XmNx); }
   void x(Position val)                { XARM_SET_VALUE(XmNx); }
   Position y() const                  { XARM_GET_VALUE(Position, XmNy); }
   void y(Position val)                { XARM_SET_VALUE(XmNy); }
   void sensitive(Boolean cond)        { XtSetSensitive(widget(),cond); }
   Boolean sensitive() const           { return XtIsSensitive(widget()); }

   /* extra */
   void disable()  { sensitive(False); }
   void enable()   { sensitive(True); }
};

#endif
