/* $Id: Registry.h,v 1.1.1.1 2001/04/09 13:33:03 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_registry_h)
#define xarm_registry_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/ConRes.h>
#include <Xm/DropSMgr.h>

#define XARM_GET_DND(t, p) t val;                       \
                           retrieve(p, (XtArgVal)&val); \
                           return val;

class DropSiteClass : public ConstraintResources
{
 protected:
   DropSiteClass() {}
 public:
   /* callbacks */
   void dragProc(XtCallbackProc fp, XtPointer data = NULL)          { XARM_SET_CALLBACK(XmNdragProc); }
   void dropProc(XtCallbackProc fp, XtPointer data = NULL)          { XARM_SET_CALLBACK(XmNdropProc); }

   /* convenience routines */
   void configureStackingOrder(Widget sibling, Cardinal stack_mode) { XmDropSiteConfigureStackingOrder(
								      widget(), sibling, stack_mode); }
   void endUpdate()                                                 { XmDropSiteEndUpdate(widget()); }
   Status queryStackingOrder(Widget *w_parent_ret, 
                             Widget **children_ret, 
                             Cardinal *num_children_ret) const
                                           { return XmDropSiteQueryStackingOrder(widget(), 
										 w_parent_ret,   
										 children_ret, 
										 num_children_ret); }

   void Register(ArgList arglist = NULL, Cardinal cnt = 0) { XmDropSiteRegister(widget(),arglist, cnt); }
   void retrieve(ArgList arglist, Cardinal cnt)            { XmDropSiteRetrieve(widget(),arglist, cnt); }
   void startUpdate()                                      { XmDropSiteStartUpdate(widget()); }
   void update(ArgList arglist, Cardinal cnt)              { XmDropSiteUpdate(widget(),arglist, cnt); }
   void unregister()                                       { XmDropSiteUnregister(widget()); }

   /* extra functionality */
   void Register(_XtString, XtArgVal);
   void retrieve(_XtString, XtArgVal) const;
   
   /* resources */
   void animationMask(Pixmap val)                { Register(XmNanimationMask, (XtArgVal)val); }
   Pixmap animationMask() const                  { XARM_GET_DND(Pixmap, XmNanimationMask); }
   void animationPixmap(Pixmap val)              { Register(XmNanimationPixmap, (XtArgVal)val); }
   Pixmap animationPixmap() const                { XARM_GET_DND(Pixmap, XmNanimationPixmap); }
   void animationPixmapDepth(int val)            { Register(XmNanimationPixmapDepth, (XtArgVal)val); }
   int animationPixmapDepth() const              { XARM_GET_DND(int, XmNanimationPixmapDepth); }
   void animationStyle(unsigned char val)        { Register(XmNanimationStyle, (XtArgVal)val); }
   unsigned char animationStyle() const          { XARM_GET_DND(unsigned char, XmNanimationStyle); }
   void dropRectangles(const XRectangle *val)    { Register(XmNdropRectangles, (XtArgVal)val); }
   XRectangle *dropRectangles() const            { XARM_GET_DND(XRectangle *, XmNdropRectangles); }
   void dropSiteActivity(unsigned char val)      { Register(XmNdropSiteActivity, (XtArgVal)val); }
   unsigned char dropSiteActivity() const        { XARM_GET_DND(unsigned char, XmNdropSiteActivity); }
   void dropSiteOperations(unsigned char val)    { Register(XmNdropSiteOperations, (XtArgVal)val); }
   unsigned char dropSiteOperations() const      { XARM_GET_DND(unsigned char, XmNdropSiteOperations); }
   unsigned char dropSiteType() const            { XARM_GET_DND(unsigned char, XmNdropSiteType); }
   void importTargets(const Atom *val)           { Register(XmNimportTargets, (XtArgVal)val); }
   Atom *importTargets() const                   { XARM_GET_DND(Atom *, XmNimportTargets); }
   void numDropRectangles(Cardinal val)          { Register(XmNnumDropRectangles, (XtArgVal)val); }
   Cardinal numDropRectangles() const            { XARM_GET_DND(Cardinal, XmNnumDropRectangles); }
   void numImportTargets(Cardinal val)           { Register(XmNnumImportTargets, (XtArgVal)val); }
   Cardinal numImportTargets() const             { XARM_GET_DND(Cardinal, XmNnumImportTargets); }
};

#endif

