/* $Id: ToggleBG.h,v 1.1.1.1 2001/04/09 13:33:34 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_togglebg_h)
#define xarm_togglebg_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/LabelG.h>
#include <Xm/ToggleBG.h>

class ToggleButtonGadgetClass : public LabelGadgetClass {
 protected:
   ToggleButtonGadgetClass() {}
   virtual WidgetClass classPointer() { return xmToggleButtonGadgetClass; }
   virtual _XtString className() { return (_XtString) "XmToggleButtonGadget"; }
 public:
   /* callbacks */
   void armCallback(XtCallbackProc fp, XtPointer data = NULL)          { XARM_SET_CALLBACK(XmNarmCallback); }
   void disarmCallback(XtCallbackProc fp, XtPointer data = NULL)       { XARM_SET_CALLBACK(XmNdisarmCallback); }
   void valueChangedCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNvalueChangedCallback); }

   /* convenience functions */
   Boolean getState() const                             { return XmToggleButtonGadgetGetState(widget()); }
   void setState(Boolean state, Boolean notify = FALSE) { XmToggleButtonGadgetSetState(widget(), state, notify); }

   /* resources */
   void fillOnSelect(Boolean val)             { XARM_SET_VALUE(XmNfillOnSelect); }
   Boolean fillOnSelect() const               { XARM_GET_VALUE(Boolean, XmNfillOnSelect); }
   void indicatorOn(Boolean val)              { XARM_SET_VALUE(XmNindicatorOn); }
   Boolean indicatorOn() const                { XARM_GET_VALUE(Boolean, XmNindicatorOn); }
   void indicatorSize(Dimension val)          { XARM_SET_VALUE(XmNindicatorSize); }
   Dimension indicatorSize() const            { XARM_GET_VALUE(Dimension, XmNindicatorSize); }
   void indicatorType(unsigned char val)      { XARM_SET_VALUE(XmNindicatorType); }
   unsigned char indicatorType() const        { XARM_GET_VALUE(unsigned char, XmNindicatorType); }
   void selectColor(Pixel val)                { XARM_SET_VALUE(XmNselectColor); }
   Pixel selectColor() const                  { XARM_GET_VALUE(Pixel, XmNselectColor); }
   void selectInsensitivePixmap(Pixmap val)   { XARM_SET_VALUE(XmNselectInsensitivePixmap); }
   Pixmap selectInsensitivePixmap() const     { XARM_GET_VALUE(Pixmap, XmNselectInsensitivePixmap); }
   void set(Boolean val)                      { XARM_SET_VALUE(XmNset); }
   Boolean set() const                        { XARM_GET_VALUE(Boolean, XmNset); }
   void spacing(Dimension val)                { XARM_SET_VALUE(XmNspacing); }
   Dimension spacing() const                  { XARM_GET_VALUE(Dimension, XmNspacing); }
   void visibleWhenOff(Boolean val)           { XARM_SET_VALUE(XmNvisibleWhenOff); }
   Boolean visibleWhenOff() const             { XARM_GET_VALUE(Boolean, XmNvisibleWhenOff); }
};

////////////////////////////////////////////
//                                        //
// ToggleButtonGadget isn't a template    //
// because it has a non-standard          //
// constructor!                           //
//                                        //
////////////////////////////////////////////

class ToggleButtonGadget : public ToggleButtonGadgetClass {
 public:
   ToggleButtonGadget(Widget w_parent,
                      char *text,
                      KeySym mn = 0,
                      _XtString acc = NULL, 
                      char *acc_text = NULL,
                      _XtString name = NULL);
   ToggleButtonGadget(Widget w_parent,
                      ArgList arglist = NULL,
                      Cardinal cnt = 0,
                      _XtString name = NULL);
   ToggleButtonGadget(_XtString name, Widget w_parent);
   ToggleButtonGadget(Widget w_parent, XarmArg &args, _XtString name);
};

#endif
