/*
 Copyright (C) 1998 Nikolay Mladenov
 Copyright (C) 1999 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#if !defined(xarm_xarmwidget_h)
#define xarm_xarmwidget_h

#include <Xarm/XarmArg.h>

/* Define the generic Get/Set methods */
#define XARM_GET_VALUE(t, p)   t val;                                     \
                               XtVaGetValues(widget(), p, &val, NULL);    \
                               return val

#define XARM_SET_VALUE(p)      XtVaSetValues(widget(), p, val, NULL)

#define XARM_GET_STRING(p)     XmString xmstr;                            \
                               char *s;                                   \
                               XtVaGetValues(widget(), p, &xmstr, NULL);  \
                               s = cvtXmStringToString(xmstr);            \
                               XmStringFree(xmstr);                       \
                               return s

#define XARM_GET_STRING_NF(p)  XmString xmstr;                            \
                               char *s;                                   \
                               XtVaGetValues(widget(), p, &xmstr, NULL);  \
                               s = cvtXmStringToString(xmstr);            \
                               return s

#define XARM_SET_STRING(p)     XmString xmstr = cvtStringToXmString(str); \
                               XtVaSetValues(widget(), p, xmstr, NULL);   \
                               XmStringFree(xmstr);

#define XARM_SET_TYPED(p)      XtVaSetValues(widget(), XtVaTypedArg, p, XmRString, val, (strlen(val) + 1), NULL)

#define XARM_GET_VALUE_W(t, p) t val;                                     \
                               XtVaGetValues(w, p, &val, NULL);           \
                               return val

#define XARM_SET_VALUE_W(p)    XtVaSetValues(w, p, val, NULL)

#define XARM_SET_CALLBACK(p)   XtAddCallback(widget(), p, (XtCallbackProc)fp, (XtPointer)data)

/* This one is here for convenience */
#define XARM_FSB_SEARCH        XmString xmstr = cvtStringToXmString(str); \
                               XmFileSelectionDoSearch(widget(),xmstr);   \
                               XmStringFree(xmstr)

///////////////////////////////////////////////////////////////////
//                                                               //
// You may notice all the fully qualified function names in all  //
// the templates below. At least the HP/UX compiler requires     //
// this.  I don't think this is strictly required by the         //
//  standard but hey, whatever it takes to get stuff to compile! //
//                                                               //
///////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
//                                                               //
// The Xarm Raw Widget interface.  Used for widgets that         //
// don't require any special treatment.                          //
//                                                               //
///////////////////////////////////////////////////////////////////

template <class XarmClass, bool manageOnCreate>
class XarmRawWidget : public XarmClass
{
public:

    XarmRawWidget(Widget w_parent, ArgList arglist = NULL, Cardinal cnt = 0,
                  _XtString name = NULL)
    {

        Widget wid = XarmClass::createWidget(name, w_parent, arglist, cnt);
	XarmClass::widget(wid);
	if (manageOnCreate) XarmClass::manage();
    }

    XarmRawWidget(_XtString name, Widget w_parent)
    {

        Widget wid = XarmClass::createWidget(name, w_parent);
	XarmClass::widget(wid);
	if (manageOnCreate) XarmClass::manage();
    }

    XarmRawWidget(Widget w_parent, XarmArg &args, _XtString name)
    {

        Widget wid = XarmClass::createWidget(name, w_parent, args.getArgs(), args.count());
	XarmClass::widget(wid);
	if (args.hasTypedArgs()) args.setTypedArgs(XarmClass::widget());
	if (manageOnCreate) XarmClass::manage();
    }
};

///////////////////////////////////////////////////////////////////
//                                                               //
// The Xarm Func Widget interface.  Used for widgets that        //
// have a special function to call for creation.                 //
//                                                               //
///////////////////////////////////////////////////////////////////

extern "C" {
typedef Widget (*xarmWidgetCreateFunc)(Widget, String, ArgList, Cardinal);
};

template <class XarmClass, xarmWidgetCreateFunc fp, bool manageOnCreate>
class XarmFuncWidget : public XarmClass
{

protected:
    virtual Widget createWidget(_XtString name, Widget w_parent,
				ArgList arglist = NULL, Cardinal cnt = 0)
    {
        if (name == NULL || *name == '\0') { name = XarmClass::className(); }
	return (*fp)(w_parent,name,arglist,cnt);
    }

public:
    XarmFuncWidget(Widget w_parent, ArgList arglist = NULL, Cardinal cnt = 0,
                   _XtString name = NULL)
    {
        Widget wid = createWidget(name, w_parent, arglist, cnt);
        XarmClass::widget(wid);
        if (manageOnCreate) XarmClass::manage();
    } 

    XarmFuncWidget(_XtString name, Widget w_parent)
    {
        Widget wid = createWidget(name, w_parent);
        XarmClass::widget(wid);
        if (manageOnCreate) XarmClass::manage();
    }
        
    XarmFuncWidget(Widget w_parent, XarmArg &args, _XtString name)
    {
        Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
        XarmClass::widget(wid);
        if (args.hasTypedArgs()) args.setTypedArgs(XarmClass::widget());
        if (manageOnCreate) XarmClass::manage();
    }
};

///////////////////////////////////////////////////////////////////
//                                                               //
// The Xarm Message Widget interface.  Used for creating widgets //
// based on MessageBox (including MessageBox). There were        //
// sufficiently many of these to warrant this.                   //
//                                                               //
///////////////////////////////////////////////////////////////////

template <class XarmClass, xarmWidgetCreateFunc fp>
class XarmMessageWidget : public XarmClass
{

protected:
    virtual Widget createWidget(_XtString name, Widget w_parent,
				ArgList arglist = NULL, Cardinal cnt = 0)
    {
        if (name == NULL || *name == '\0') { name = XarmClass::className(); }
	return (*fp)(w_parent,name,arglist,cnt);
    }

public:
    XarmMessageWidget(Widget w_parent, ArgList arglist = NULL, Cardinal cnt = 0,
                   _XtString name = NULL)
    {
        Widget wid = createWidget(name, w_parent, arglist, cnt);
        XarmClass::widget(wid);
    } 

    XarmMessageWidget(_XtString name, Widget w_parent)
    {
        Widget wid = createWidget(name, w_parent);
        XarmClass::widget(wid);
    }
        
    XarmMessageWidget(Widget w_parent, XarmArg &args, _XtString name)
    {
        Widget wid = createWidget(name, w_parent, args.getArgs(), args.count());
        XarmClass::widget(wid);
        if (args.hasTypedArgs()) args.setTypedArgs(XarmClass::widget());
    }

    // This is the alternate constructor for a MessageBox!!!!
    XarmMessageWidget(Widget w_parent, char *mesg, _XtString name = NULL)
    {
        Widget wid = createWidget(name, w_parent);
        XarmClass::widget(wid);
	XarmClass::messageString(mesg);
    }
        
};

///////////////////////////////////////////////////////////////////
//                                                               //
//  This is useful in cases like:                                //
//                                                               //
//  SelectionDialog *dialog = new SelectionDialog(.........);    //
//  XarmWidget<ListClass> list(dialog->getChild(XmDIALOG_LIST)); //
//  list.add("something");                                       //
//  list.replace( .....;                                         //
//                                                               //
///////////////////////////////////////////////////////////////////

template <class XarmClass>
class XarmWidget: public XarmClass {

protected:
    _XtString className() { return "WrappedWidget"; }

public:
    XarmWidget(Widget w) : XarmClass()
    {
        XarmClass::widget(w);
    }

    XarmWidget<XarmClass> &operator = ( Widget w )
    {
        XarmClass::widget(w);
	return *this;
    }

    XarmWidget<XarmClass> &operator = ( XarmWidget<XarmClass> & wc)
    {
        return this->operator = (wc.widget());
    }

    XarmWidget(XarmWidget<XarmClass> & wc) : XarmClass()
    {
        XarmClass::widget(wc.widget());
    }

    ~XarmWidget()
    {
        XarmClass::widget(0);
    }
};

#endif  // xarm_xarmwidget_h
