#ifndef _XmDialP_h
#define _XmDialP_h

#include <math.h>
#ifndef M_PI
#define M_PI 3.1415926
#endif
#define PD2 (M_PI / 2.0)

#include <Xmext/Dial.h>
#if XmVersion == 1001
#include <Xm/XmP.h>
#else
#include <Xm/PrimitiveP.h>
#endif

#define XmRDialStyle "RDialStyle"

typedef struct _XmDialClassPart
{
   caddr_t extension;
} XmDialClassPart;


/*  Full class record declaration for Dial class  */

typedef struct _XmDialClassRec
{
   CoreClassPart        core_class;
   XmPrimitiveClassPart primitive_class;
   XmDialClassPart     	dial_class;
} XmDialClassRec;

externalref XmDialClassRec xmDialClassRec;


/*  The Dial instance record  */

typedef struct _XmDialPart
{
    /* resources */

    int           minimum;
    int           maximum;
    int           value;
    int           tick_increment;
    int           tick_size;
    int           arc_margin;
    int           border_margin;
    unsigned char processing_direction;
    Boolean       fill;
    Boolean       show_value;
    Boolean       show_min_max;
    Boolean       show_percentage;
    Boolean       show_hub;
    XmFontList    fontlist;
    DialStyle     style;

    /* Private state */

    GC            foreground_GC;	
    GC            background_GC;
    GC            text_erase_GC;
    XFontStruct  *font;
    int           prev_value;
    int           xorigin;
    int           yorigin;
    int           xradius;
    int           yradius;
    int           xinner_radius;
    int           yinner_radius;
    int           arc_offset;
    int           border_offset;
    int           text_height;
} XmDialPart;


/*  Full instance record declaration  */

typedef struct _XmDialRec
{
   CorePart	   core;
   XmPrimitivePart primitive;
   XmDialPart      dial;
} XmDialRec;

#endif
