/* $Id: CObject.C,v 1.1.1.1 2001/04/09 13:34:29 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 Copyright (C) 1996 Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

/* Include(s): */
#include <Xarm/CObject.h>
#include <Xarm/CallbackP.h>

#define Unused(x) (void)(x)


void
CObject::addEventHandler(Widget w,
                         EventMask em,
                         _XtBoolean nm,
                         p_event_msg mfp, 
                         XtPointer closure)
{

   EventInfo<CObject> *pei = new EventInfo<CObject>;

   if (pei == NULL) return;

   pei->_target      = this;
   pei->_widget      = w;
   pei->_callback    = mfp;
   pei->_em          = em;
   pei->_nonmaskable = nm;
   pei->_closure     = closure;

   registerEventHandler(pei);
}

void
CObject::removeEventHandler(Widget w,
                         EventMask em,
                         _XtBoolean nm,
                         p_event_msg mfp, 
                         XtPointer closure)
{
   EventInfo<CObject> ei;

   ei._target      = this;
   ei._widget      = w;
   ei._callback    = mfp;
   ei._em          = em;
   ei._nonmaskable = nm;
   ei._closure     = closure;

   unregisterEventHandler(&ei);

}

void
CObject::addCallback(Widget w,
                     _XtString type, 
                     p_msg mfp, 
                     XtPointer closure)
{
    CallbackInfo<CObject> *pci = new CallbackInfo<CObject>;

    if (pci == NULL) return;

    pci->_target   = this;
    pci->_widget   = w;
    pci->_callback = mfp;
    pci->_closure  = closure;
    pci->_type     = type;

    registerCallback(pci);
}

void 
CObject::removeCallback(Widget w, 
                        _XtString type, 
                        p_msg mfp, 
                        XtPointer closure)
{
    CallbackInfo<CObject> ci;

    ci._target   = this;
    ci._widget   = w;
    ci._callback = mfp;
    ci._closure  = closure;
    ci._type     = type;

    unregisterCallback(&ci);

}

void
CObject::removeAllCallbacks(Widget w,
                            _XtString type)
{

  ::removeAllCallbacks(w, type);
}

void 
CObject::addProtocolCallback(Widget w,
                             Atom property,
                             Atom proto_atom,
                             p_msg fp,
                             XtPointer closure)
{
    ProtocolInfo<CObject> *ppi = new ProtocolInfo<CObject>;

    if (ppi == NULL) return;

    ppi->_target   = this;
    ppi->_widget   = w;
    ppi->_callback = fp;
    ppi->_closure  = closure;
    ppi->_property = property;
    ppi->_protocol = proto_atom;

    registerProtoCallback(ppi);
}

void
CObject::removeProtocolCallback(Widget w,
                            Atom property,
                            Atom proto_atom,
                            p_msg fp,
                            XtPointer closure)
{
    ProtocolInfo<CObject> pi;

    pi._target   = this;
    pi._widget   = w;
    pi._callback = fp;
    pi._closure  = closure;
    pi._property = property;
    pi._protocol = proto_atom;

    unregisterProtoCallback(&pi);
}
   
void 
CObject::addWMProtocolCallback(Widget w,
                            Atom protocol,
                            p_msg fp,
                            XtPointer closure)
{
   addProtocolCallback(w,
                       XM_WM_PROTOCOL_ATOM(w),
                       protocol,
                       fp,
                       closure);   
}
   
void 
CObject::removeWMProtocolCallback(Widget w,
                            Atom protocol,
                            p_msg fp,
                            XtPointer closure)
{
   removeProtocolCallback(w,
                          XM_WM_PROTOCOL_ATOM(w),
                          protocol,
                          fp,
                          closure);   
}

/* Application callback routines */

XtWorkProcId
CObject::addWorkProc(XtAppContext ac, 
                     p_work_msg fp,
                     XtPointer closure)
{
    WorkInfo<CObject> *pwi = new WorkInfo<CObject>;

    if (pwi == NULL) return (XtWorkProcId)0;

    pwi->_target   = this;
    pwi->_callback = fp;
    pwi->_closure  = closure;

    return registerWorkProc(pwi, ac);
}

void
CObject::removeWorkProc(XtWorkProcId i)
{
    ::removeWorkProc(i);
}

XtIntervalId
CObject::addTimeOut(XtAppContext ac, 
                     unsigned long i,
                     p_timer_msg fp,
                     XtPointer closure)
{
    TimerInfo<CObject> *pti = new TimerInfo<CObject>;

    if (pti == NULL) return (XtIntervalId)0;

    pti->_target   = this;
    pti->_callback = fp;
    pti->_closure  = closure;

    return registerTimeOut(pti, ac, i);
}

void
CObject::removeTimeOut(XtIntervalId i)
{
    ::removeTimeOut(i);
}

XtInputId
CObject::addInput(XtAppContext ac,
                  int source,
                  XtPointer condition,
                  p_input_msg fp,
                  XtPointer closure)
{
    InputInfo<CObject> *pii = new InputInfo<CObject>;

    if (pii == NULL) return (XtInputId)0;

    pii->_target   = this;
    pii->_callback = fp;
    pii->_closure  = closure;

    return registerInput(pii, ac, source, condition);
}

void
CObject::removeInput(XtInputId i)
{
    ::removeInput(i);
}

/* CObject init routine */
CObject::CObject()
{
}

/* CObject cleanup routine */
CObject::~CObject()
{
}

/* */
