/* $Id: ImageCache.C,v 1.1.1.1 2001/04/09 13:34:41 glgay Exp $ */
/*
 Copyright (C) 1996 Peter Williams
 Copyright (C) 1998 Gerald L. Gay

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave,
 Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Xm/XmP.h>
#include <string>
#include <map>
#include <Xarm/XarmXpm.h>
#include <Xarm/Xarm.h>

#if defined(XARM_HAS_NAMESPACES)
typedef std::map<std::string, Pixmap, std::less<std::string> > ImageCache;
#else
typedef map<string, Pixmap, less<string> > ImageCache;
#endif


#if defined(XARM_HAS_NAMESPACES)
typedef std::pair<const std::string, Pixmap> ImageElem;
#else
typedef pair<const string, Pixmap> ImageElem;
#endif

static char *
_internal_strdup(const char *str)
{
   char *tmp;
   if(str == NULL) 
   { 
      return NULL; 
   }
   tmp = (char *) XtMalloc(sizeof(char)*strlen(str)+1);
   return strcpy(tmp,str);
}

/* 
*  If it matches the name then fine grab it.
*  FIX ME:
*  An optional width, height, and depth should be added
*  for exactness if desired.
*/

static ImageCache _global_image_cache;

static char * _search_path = NULL;

static char * _search_type[] = { "pixmaps", 
                                 "icons", 
                                 "mini-icons",
                                 "bitmaps" };

static char *_set_pattern = "%%B:"
                            "%s/%%L/%%T/%%N/%%B:"
                            "%s/%%l/%%T/%%N/%%B:"
                            "%s/%%T/%%N/%%B:"
                            "%s/%%L/%%T/%%B:"
                            "%s/%%l/%%T/%%B:"
                            "%s/%%T/%%B:"
                            "%s/%%T/%%B:"
                            "%s/%%B:"
                            "/usr/lib/X11/%%L/%%T/%%N/%%B:"
                            "/usr/lib/X11/%%l/%%T/%%N/%%B:"
                            "/usr/lib/X11/%%T/%%N/%%B:"
                            "/usr/lib/X11/%%L/%%T/%%B:"
                            "/usr/lib/X11/%%l/%%T/%%B:"
                            "/usr/lib/X11/%%T/%%B:"
                            "/usr/include/X11/%%T/%%B";


static void
__XarmCreateSearchPath()
{
   char *XBMLANGPATH;
   char *XAPPLRESDIR;

   XBMLANGPATH = _internal_strdup((char *)getenv("XBMLANGPATH"));
   XAPPLRESDIR = _internal_strdup((char *)getenv("XAPPLRESDIR"));

   if(XBMLANGPATH)
   {
      _search_path = XBMLANGPATH;

      if(XAPPLRESDIR)
      {
         XtFree(XAPPLRESDIR);
      }
   }
   else 
   {
      char *HOME;
      int HOME_len;

      HOME = (char *)getenv("HOME");

      if (HOME != NULL) {
          HOME_len = strlen(HOME);
      } else {
          HOME_len = 0;
      }

      if(XAPPLRESDIR)
      {
         int XAPPLRESDIR_len;

         XAPPLRESDIR_len = strlen(XAPPLRESDIR);

         _search_path = (char*)XtMalloc(strlen(_set_pattern)
                                       + XAPPLRESDIR_len * 6
                                       + HOME_len * 2 + 1);

         sprintf(_search_path, _set_pattern,
                 XAPPLRESDIR,XAPPLRESDIR,XAPPLRESDIR,
                 XAPPLRESDIR,XAPPLRESDIR,XAPPLRESDIR,
                 HOME,HOME);

      }
      else 
      {
         _search_path = (char*)XtMalloc(strlen(_set_pattern)
                                        + HOME_len * 8 + 1);

         sprintf(_search_path, _set_pattern,
                 HOME,HOME,HOME,HOME,HOME,HOME,HOME,HOME);
      }
   }
}

static Pixmap
_XarmGetPixmap(Display *dpy, Window w, const char *fname)
{
   static Colormap _cmap;

   XarmXpmAttributes xpm_attrib;
   Pixmap pmap;
   Pixmap mask;

   ImageCache::iterator icit;

   char *pathname_to_pixmap = NULL;

   /* initialize colormap if it hasn't been done */
   if(_cmap == (Colormap) NULL)
   {
      XWindowAttributes w_attrib;
      XGetWindowAttributes(dpy,w,&w_attrib);
      _cmap=w_attrib.colormap;
   }

   /*
    * NOTE:  If one of the following lines fails to compile,
    *        see the note at the top of this file and send
    *        me an email.      - Thanks.
    */

   icit = _global_image_cache.find(fname);
   if (icit == _global_image_cache.end()) pmap = XmUNSPECIFIED_PIXMAP;
   else                                   pmap = (*icit).second;

   if (pmap != XmUNSPECIFIED_PIXMAP)
   {
      return pmap;
   }

   if(_search_path == NULL)
   {
      __XarmCreateSearchPath();
   }
   
   /* 
    * Attempt to find pixmap in search_path 
    * if an absolute path was not given. 
    */
   if(fname != NULL && fname[0]=='/')
   {
      pathname_to_pixmap = _internal_strdup(fname);
   }
   else
   {
      SubstitutionRec sub;
      Cardinal i, n;

      sub.match = 'B';
      sub.substitution = const_cast<char *>(fname);
      
      n = XtNumber(_search_type);

      for(i=0; 
          i<n && pathname_to_pixmap==NULL; 
          i++)
      {
         pathname_to_pixmap = XtResolvePathname(dpy,
                                                _search_type[i],
                                                NULL,
                                                NULL,
                                                _search_path,
                                                &sub,
                                                1,
                                                NULL); 
      }
   }
   
   if (pathname_to_pixmap == NULL
       || strlen(pathname_to_pixmap) == 0)
   {
      return XmUNSPECIFIED_PIXMAP;
   }

   xpm_attrib.colormap=_cmap;
   xpm_attrib.closeness=40000;
   xpm_attrib.valuemask=XarmXpmSize | XarmXpmReturnPixels 
                        | XarmXpmColormap | XarmXpmCloseness;

   if(_XarmXpmReadFileToPixmap(dpy,w,pathname_to_pixmap,
                                &pmap,&mask,&xpm_attrib) == XarmXpmSuccess)
   {

     /*
      * NOTE: If the following line fails to compile,
      *       see the note at the top of this file and
      *       send me an email.     -  Thanks.
      */

      _global_image_cache.insert( ImageElem(fname,pmap) );
   }
   else
   {
      /* could not find it so lets return it as unspecified */
      pmap = XmUNSPECIFIED_PIXMAP;
   }

   XtFree(pathname_to_pixmap);

   return pmap;
}

Pixmap
XarmGetPixmap(Widget w, const char *fname)
{
   Screen *screen;
   Window root;
   Display *dpy;

   /* The widget might not have a window yet so just use the root window */
   screen = XtScreen(w);
   root = RootWindowOfScreen(screen);
   dpy = XtDisplay(w);

   return _XarmGetPixmap(dpy, root, fname);

}

static Boolean
_XarmCvtStringToPixmap(Display *dpy,
                        XrmValue *args,
                        Cardinal *num_args,
                        XrmValue *from,
                        XrmValue *to,
                        XtPointer *converter_data)
{
   static Pixmap _pmap;
   Screen *screen;
   Window root;
   char *name;

   if (*num_args != 1)
   {
      XtErrorMsg("wrongParameters",
                 "cvtStringToPixmap",
                 "XtToolkitError",
                 "String to Pixmap conversion needs screen argument",
                 NULL,
                 NULL);
   }


   /* get arguments */
   screen = *((Screen **) args[0].addr);
   name = (char *)from->addr;

   /* grab root window */
   root = RootWindowOfScreen(screen);

   /* over kill check */
   if (name == NULL
       || strcmp(name,"None") == 0
       || strcmp(name,"XmUNSPECIFIED_PIXMAP") == 0)
   {
      _pmap = XmUNSPECIFIED_PIXMAP;
   }
   else {
      _pmap = _XarmGetPixmap(dpy, root, name);
   }

   if (to->addr == NULL)
   {
      to->addr = (XPointer)&_pmap;
      to->size = sizeof(Pixmap);
   }
   else
   {
      if (to->size >= sizeof(Pixmap))
      {
         *((Pixmap *)to->addr) = _pmap;
         to->size = sizeof(Pixmap);
      }
      else
      {
         XtDisplayStringConversionWarning(dpy, (char*)from->addr, XmRPixmap);
      }
   }

   /* now keep compiler happy */
   converter_data = converter_data;

   return True;
}

static void
_XarmRegisterConverters()
{
   static XtConvertArgRec args[] = {
      {
         XtBaseOffset,
         (XtPointer)XtOffsetOf(WidgetRec, core.screen),
         sizeof(Screen *)
      }
   };

   XtSetTypeConverter(XmRString,  /* source type */
                      XmRPixmap,  /* target type */
                      _XarmCvtStringToPixmap, /* converter routine */
                      args,       /* args for converter routine */
                      XtNumber(args), /* number of args for converter */
                      XtCacheNone, /* caching instructions */
                      NULL);      /* destructor function */

   XtSetTypeConverter(XmRString,  /* source type */
                      XmRXmBackgroundPixmap,  /* target type */
                      _XarmCvtStringToPixmap, /* converter routine */
                      args,       /* args for converter routine */
                      XtNumber(args), /* number of args for converter */
                      XtCacheNone, /* caching instructions */
                      NULL);      /* destructor function */
}

void
XarmRegisterConverters()
{
   _XarmRegisterConverters();
}

static Pixmap
_XarmGetPixmapFromData(Display *dpy, Window w, const char **pdata)
{
   static Colormap _cmap;

   Pixmap pixmap_to_return;
   Pixmap mask;
   XarmXpmAttributes xpm_attrib;

   /* initialize colormap if it hasn't been done */
   if(_cmap == (Colormap) NULL)
   {
      XWindowAttributes w_attrib;
      XGetWindowAttributes(dpy,w,&w_attrib);
      _cmap=w_attrib.colormap;
   }

   xpm_attrib.colormap=_cmap;
   xpm_attrib.closeness=40000;
   xpm_attrib.valuemask=XarmXpmSize | XarmXpmReturnPixels 
                        | XarmXpmColormap | XarmXpmCloseness;

   /* Do not add these pixmaps to the cache since you
    * can not assign a meaningful id to them. 
    */
   if(_XarmXpmCreatePixmapFromData(dpy,w, pdata, &pixmap_to_return,
                                    &mask, &xpm_attrib) != XarmXpmSuccess)
   {
      pixmap_to_return = XmUNSPECIFIED_PIXMAP;
   }

   return pixmap_to_return;
}

Pixmap
XarmGetPixmapFromData(Widget w, const char **pdata)
{
   Screen *screen;
   Window root;
   Display *dpy;

   /* The widget might not have a window yet so just use the root window */
   screen = XtScreen(w);
   root = RootWindowOfScreen(screen);
   dpy = XtDisplay(w);

   return _XarmGetPixmapFromData(dpy,root,pdata);
}


