/* $Id: Text.C,v 1.1.1.1 2001/04/09 13:34:55 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/Text.h>
/* TextClass member functions */


/* convenience functions */

Boolean 
TextClass::findString(XmTextPosition start, const char *str, XmTextDirection direction, XmTextPosition *pos)
{
   return XmTextFindString(widget(), start, const_cast<char *>(str), direction, pos);
}

Boolean 
TextClass::findStringWcs(XmTextPosition start, const wchar_t *str, XmTextDirection direction, XmTextPosition *pos)
{
   return XmTextFindStringWcs(widget(), start, const_cast<wchar_t *>(str), direction, pos);
}

void
TextClass::insert(XmTextPosition pos, const char *str)
{
   XmTextInsert(widget(), pos, const_cast<char *>(str));
}

void
TextClass::insertWcs(XmTextPosition pos, const wchar_t *str)
{
   XmTextInsertWcs(widget(), pos, const_cast<wchar_t *>(str));
}

void
TextClass::replace(XmTextPosition from, XmTextPosition to, const char *val)
{
   XmTextReplace(widget(), from, to, const_cast<char *>(val));
}

void
TextClass::replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val)
{
   XmTextReplaceWcs(widget(), from, to, const_cast<wchar_t *>(val));
}

void 
TextClass::setString(const char *str)
{
   XmTextSetString(widget(), const_cast<char *>(str));
}

void 
TextClass::setStringWcs(const wchar_t *str)
{
   XmTextSetStringWcs(widget(), const_cast<wchar_t *>(str));
}

