/* $Id: TextF.C,v 1.1.1.1 2001/04/09 13:34:57 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/

#include <Xarm/TextF.h>
/* TextFieldClass member functions */

/* convenience routines */

void
TextFieldClass::insert(XmTextPosition pos, const char *str)
{
   XmTextFieldInsert(widget(), pos, const_cast<char *>(str));
}

void
TextFieldClass::insertWcs(XmTextPosition pos, const wchar_t *str)
{
   XmTextFieldInsertWcs(widget(), pos, const_cast<wchar_t *>(str));
}

void
TextFieldClass::replace(XmTextPosition from, XmTextPosition to, const char *val)
{
   XmTextFieldReplace(widget(), from, to, const_cast<char *>(val));
}

void
TextFieldClass::replaceWcs(XmTextPosition from, XmTextPosition to, const wchar_t *val)
{
   XmTextFieldReplaceWcs(widget(), from, to, const_cast<wchar_t *>(val));
}

void 
TextFieldClass::setString(const char *str)
{
   XmTextFieldSetString(widget(), const_cast<char *>(str));
}

void 
TextFieldClass::setStringWcs(const wchar_t *str)
{
   XmTextFieldSetStringWcs(widget(), const_cast<wchar_t *>(str));
}

