#include <Xclasses/Xclasses.h>
#include <X11/xpm.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define MAXBREITE 		300
#define STARTBREITE		150
#define FILENAMESIZE 	100
#define VORGABEN		10

XCprogram	myprg("imggen",
					XCP_Version,"0.8",
					XCP_Copyright,"(c) by Jrgen Schmitz 1996/1997",
					XCP_Author,"Jrgen Schmitz",
					XCP_EMail,"schmitzj@fsai.fh-trier.de",
					XCP_XC_logo,
					XCP_Done);

char *vorgaben[VORGABEN]={"Mailbox FSAI","Fachschaft AI",
						  "Rechenzentrum","Fachbereich AI",
						  "PGP","Schwarzes Brett",
						  "Anzeigenbrse","interessante Links",
						  "Links in alle Welt","WebCam"
						 };

appwindow mywin;
graphic gfx;
input txt;
fileinput filename;
button ende,start,savexpm,savegif;
group maingp;
bordergroup buts,outp;
slider size;
menu mymenu;
fontgroup fnt;
mxknob ismode;
char *modes[]={"normal","ber","aktiv",NULL};

int picheight;
file_dialog fldg;

int breite=STARTBREITE;

#define MAXCOLS	15
int cols[MAXCOLS];
#define BALKEN	15

void paint(void)
{
	gfx.Foreground(cols[6]);
	gfx.Clear();

	char austext[30];
	int x,y;
	txt.Input(austext);
//	gfx.Font("-*-helvetica-*-r-*-*-14-*-*-*-*-*-*-*");
	gfx.Font(fnt.GetFont());
	picheight=gfx.FontHeight();

	x=(breite-BALKEN-gfx.StringLength(austext))/2;
	y=gfx.FontAscent();

	switch(ismode.Selected())
	{
		case 0: // normal
			gfx.Foreground(cols[0]);
			gfx.FillRectangle(BALKEN,0,breite-BALKEN,picheight);

//			gfx.Foreground(cols[4]);
//			gfx.DrawString(BALKEN+x-1,y-1,austext);

			gfx.Foreground(cols[3]);
			gfx.DrawString(BALKEN+x+1,y+1,austext);

			gfx.Foreground(cols[12]);
			gfx.DrawString(BALKEN+x,y,austext);
			break;
		case 1: // ber
			gfx.Foreground(cols[2]);
			gfx.FillRectangle(BALKEN,0,breite-BALKEN,picheight);
			gfx.Foreground(cols[5]);
			gfx.DrawString(BALKEN+x,y,austext);
			break;
		case 2: // aktiv
			gfx.Foreground(cols[11]);
			gfx.FillRectangle(BALKEN,0,breite-BALKEN,picheight);
			gfx.Foreground(cols[5]);
			gfx.DrawString(BALKEN+x,y,austext);
			break;
	}
	gfx.Foreground(cols[4]);
	gfx.Line(0,picheight,breite-1,picheight);
	gfx.Line(breite-1,0,breite-1,picheight);
	picheight++;
	gfx.Foreground(cols[1]);
	gfx.FillRectangle(0,0,BALKEN,picheight);
	gfx.Foreground(cols[7]);
	gfx.FillRectangle(BALKEN-2,0,1,picheight);
	gfx.Foreground(cols[8]);
	gfx.FillRectangle(BALKEN-1,0,1,picheight);
	gfx.Foreground(cols[9]);
	gfx.FillRectangle(1,0,1,picheight);
	gfx.Foreground(cols[10]);
	gfx.FillRectangle(0,0,1,picheight);

	gfx.Draw();
}

int main(int argc, char *argv[])
{
	mywin.InitSize(10,10,40);
	if (!mywin.Init(argc,argv))
	{
		printf("Error:\nCan't open display\n");
		exit(1);
	}

	mywin.Title("Icon-Generator IMGGEN");
	mywin.IconTitle("IMGGEN");

	maingp.Horiz();
	 buts.Vert();
	 buts.Title("Kontrolle");
	  txt.Text("Text:");
	  txt.MaxChars(25);
	  txt.ID(1);
	 buts.Add(txt);
	  start.Text("Erzeugen");
	  start.ID(1);
	 buts.Add(start);

	  ruler r1;
	  r1.Space(5);
	 buts.Add(r1);
	  filename.ModeSaveFile();
	 buts.Add(filename,"Filename:");
	  savexpm.Text("Sichern als XPM");
	  savexpm.ID(4);
	 buts.Add(savexpm);
	  savegif.Text("Sichern als GIF");
	  savegif.ID(5);
	 buts.Add(savegif);

	  ruler r2;
	  r2.Space(5);
	 buts.Add(r2);
	  ende.Text("Ende");
	  ende.ID(2);
	 buts.Add(ende);
	maingp.Add(buts);
	 outp.Vert();
	 outp.Title("Ausgabe");
	 outp.Center();
	  gfx.Size(MAXBREITE,60);
	 outp.Add(gfx);
	  size.MinValue(10);
	  size.MaxValue(MAXBREITE);
	  size.Value(breite);
	  size.Horiz();
	  size.ID(3);
	 outp.Add(size);
	  ismode.Items(modes);
	  ismode.Selected(0);
	  ismode.Horiz();
	 outp.Add(ismode);

	  ruler r3;
	  r3.Space(5);
	 outp.Add(r3);
	 outp.Add(fnt);
	maingp.Add(outp);

	mymenu.AddMenu("Datei");
	mymenu.Add("Programm beenden","q",1);
	mymenu.AddMenu("Vorgaben");
	for(int i=0;i<VORGABEN;i++)
	{
		char sc[2];
		sc[0]='a'+i;
		sc[1]=0;
		mymenu.Add(vorgaben[i],sc,i+1);
	}
//	mymenu.AddHelpMenu("Xclasses");
//	mymenu.Add("kein Eintrag",1);
//	mymenu.LockItem(3,1);
	mymenu.ID(100);
	mywin.SetGroup(maingp);
	mywin.SetMenu(mymenu);
	mywin.Create();

	cols[0]=mywin.AllocColor(0xdddd,0xdddd,0xdddd);
	cols[1]=mywin.AllocColor(0xffff,0x0000,0x0000);
	cols[2]=mywin.AllocColor(0xffff,0xffff,0x0000);
	cols[3]=mywin.AllocColor(0xeeee,0xeeee,0xeeee);
	cols[4]=mywin.AllocColor(0x9999,0x9999,0x9999);
	cols[5]=mywin.AllocColor(0x0000,0x0000,0x0000);
	cols[6]=mywin.AllocColor(0xffff,0xffff,0xffff);
	cols[7]=mywin.AllocColor(0xdddd,0x0000,0x0000);
	cols[8]=mywin.AllocColor(0x8888,0x4444,0x0000);
	cols[9]=mywin.AllocColor(0xffff,0x4444,0x4444);
	cols[10]=mywin.AllocColor(0xffff,0xaaaa,0xaaaa);
	cols[11]=mywin.AllocColor(0xffff,0xcccc,0x0000);
	cols[12]=mywin.AllocColor(0x4444,0x4444,0x4444);

	int pende=0,r;
	while (!pende)
	{
		r=mywin.NextEvent();
		if (r==EV_WINDOWCLOSE)
		{
			if (mywin.CloseMe()) pende=1;
		}
		else if (r==EV_GADGET)
		{
			switch (mywin.ID())
			{
				case 1:
					paint();
					break;
				case 2:
					pende=1;
					break;
				case 3:
					breite=size.Value();
					break;
				case 4:
					{
						char filenme[FILENAMESIZE];
						XpmAttributes xatr;
						filename.GetFile(filenme,FILENAMESIZE);
						xatr.width=breite;
						xatr.height=picheight;
						xatr.valuemask=XpmSize;
						XpmWriteFileFromPixmap(mywin.display(),filenme,gfx.pixmap(),0,&xatr);
					}
					break;
				case 5:
					{
						char filenme[FILENAMESIZE];
						char com[200],*tmp=tmpnam(NULL);
						XpmAttributes xatr;
						filename.GetFile(filenme,FILENAMESIZE);
						xatr.width=breite;
						xatr.height=picheight;
						xatr.valuemask=XpmSize;
						XpmWriteFileFromPixmap(mywin.display(),tmp,gfx.pixmap(),0,&xatr);
						sprintf(com,"xpmtoppm %s|ppmtogif >%s",tmp,filenme);
						system(com);
						remove(tmp);
					}
					break;
				case 100:
					if (mymenu.Menu()==1 && mymenu.MID()==1) pende=1;
					else if (mymenu.Menu()==2)
					{
						txt.Default(vorgaben[mymenu.MID()-1]);
						paint();
					}
					break;
			}
		}
	}
	mywin.Close();
	return 0;
}
